//
// ci2desk.C  last changed Aug. 29, 1994
// A desktop demo using CommonInteract objects.
// This application should run under Motif and Xaw
//
// There are plans to add CommonInteract as an extension to TIP.
// Whether, and when this will be done depends on the author's  
// success with upcoming commercial TIP projects since it means a
// lot of work to implement the server functionality in non X
// GUI environments...
//
// Usage: double-clicking an object (CI Activate primitive) allows
//        changing its properties. Clicking a document with the middle
//        mouse button pops up another object showing its contents.
//        Moving a document over printer, copier or trash can invokes
//        the respective operation.
//
// You may change the Makefile to compile this sample with -DTEST_COLORS
// to get colored objects, or with -DTEST_IMAGES to get pictures rather
// than simple rectangles. (Its up to you to use some better icons :-)
//

#include <string.h>
#include <iostream.h>
#include <strstream.h>


#define GPR_DEFAULT_FILL GPR_SOLID

#include <xmCi2.h>

struct copyInfo;

class Document : public CiObject
{
	char* contents;
	CiObject* prevParent;
	gprPoint prevLoc;

	void showInfo(void*);
	void edit(void*);
	void storeLoc(void*);

	void print(void*);
	void copy(void*);
	void moveBack(void*);
	void drop(void*);

	char* className()	{ return("Document"); }
public:
	Document(char* = "noname", int = -1, int = -1);
	~Document();

	Document* setContents(char* txt)	{ delete contents; contents = strcpy(new char[strlen(txt) + 1], txt); return(this); }
};

class Printer : public CiObject
{
friend class Copier;
	int copies;

	void printIt(ciClientData*);
	void setup(void*);

	void drop(void*);

	char* className()	{ return("Printer"); }
public:
	Printer(char* = "Printer", int = -1, int = -1, bool = TRUE);
};

class Copier : public Printer
{
	void copyIt(ciClientData*);

	char* className()	{ return("Copier"); }
public:
	Copier(char* = "Copier", int = -1, int = -1);
};

/*
class Filer : public CiObject
{
};
*/

class TrashCan : public CiObject
{
	void dropIt(ciClientData*);
public:
	TrashCan(char* = "Trash Can", int x = -1, int y = -1);
};

class Desktop : public XmCiWorld
{
	CiObject* popupDoc;
public:
	Desktop(char* n, int x, int y, int w, int h) : XmCiWorld(n, x, y, w, h) { popupDoc = NULL; /* setBackground((gprColor)getNamedColor("LightBlue")); */ }

	bool userClick(DrawPrim*, int, int, bool sr);
	void showInfo(char*, int, int);
};

// misc declarations /////////////////////////////////////////////////

struct copyInfo
{
	int count;
	CiObject** copies;

	copyInfo(int);
	~copyInfo()		{ delete copies; }
};

copyInfo::copyInfo(int n)
{
	copies = new CiObject*[(count = n)];
	for(int i = 0; i < n; i++)
		copies[i] = NULL;
}

// implementation ////////////////////////////////////////////////////


Document::Document(char* name, int x, int y) : CiObject(new Rectangle(x, y, 50, 60), name)
{
	contents = new char[500];
	prevParent = NULL;
	prevLoc.x = x;
	prevLoc.y = y;

	strcpy(contents, "This is the contents of the document named ");
	strcat(contents, name);

	setText(name);
#ifdef TEST_COLORS
	lineColor("Blue")->fillColor("Yellow");
#endif
#ifdef TEST_IMAGES
	setImage(getRuntimeImage("icon3.gif"));
#endif
	setCallback(Select, this, CBK(Document, showInfo));

	setCallback(Move, this, CBK(Document, storeLoc), TRUE, TRUE);
	setCallback(Assign, this, CBK(Document, storeLoc), TRUE, TRUE);
	setCallback(Activate, this, CBK(Document, edit));
	allowAssigningTo("Printer*", "Copier*", "Trash*", "WORLD", NULL);
	allowAssignmentOf("DocumentClass", NULL);
	registerMethod("print", CBK(Document, print), "char**");
	registerMethod("copy", CBK(Document, copy), "copyInfo*");
	registerMethod("moveBack", CBK(Document, moveBack));
	registerMethod("drop", CBK(Document, drop), "bool*");
};

Document::~Document()
{
	cerr << "document destroyed...\n";
	delete contents;
}

void Document::showInfo(void*)
{
	if(getWorld()->buttonsPressed() & BUTTON(2))
		((Desktop*)getWorld())->showInfo(contents, origin().x, corner().y);
}

void Document::edit(void*)
{
	char* reply;
	gprColor fg = getLineColor(), bg = getFillColor();

	lineColor(bg)->fillColor(fg)->update();
	getWorld()->refresh();

	if(reply = (new XmPrompter("Enter document text: ", "Edit Document", contents, XmSmboxQuestion, getWorld()))->prompt())
		strcpy(contents, reply);

	lineColor(fg)->fillColor(bg)->update();
	getWorld()->refresh();

}

void Document::storeLoc(void*)
{
	prevParent = getParent();
	prevLoc = origin();
}

void Document::print(void* ptr)
{
	*((char**)ptr) = contents;
}

Document* doc;

void Document::copy(void* ptr)
{
	copyInfo* inf = (copyInfo* )ptr;
	for(int i = 0; i < inf->count; i++)
	{	cerr << this << " " << getName() << " copy...\n";
		inf->copies[i] = (new Document(getName()))->setContents(contents);
	}
}

void Document::moveBack(void*)
{
// cerr << "back to " << (prevParent ? prevParent->getName() : "WORLD") << " at " <<
//	prevLoc.x << "@" << prevLoc.y << "\n";
	assign(prevParent, prevLoc.x, prevLoc.y);
}

void Document::drop(void* qry)
{
	ostrstream aMsg;

	aMsg << "Are you sure to delete\nthe document " << getName() << "?"; aMsg.put('\0');
	*((bool*)qry) = (new XmMsgBox(aMsg.str() , "Delete", XmSmboxQuestion, getWorld()))->showMsg();
}


Printer::Printer(char* name, int x, int y, bool initAll) : CiObject(new Rectangle(x, y, 100, 80), name)
{
	copies = 1;

	setText(name);
#ifdef TEST_COLORS
	lineColor("Brown")->fillColor("LightPink");
#endif
#ifdef TEST_IMAGES
	setImage(getRuntimeImage("icon1.gif"));
#endif
	allowAssigningTo("TrashCan", NULL);
	allowAssignmentOf("doc*" /* "DocumentClass" */, NULL);
	if(initAll)
		setCallback(ChangeContents, this, CBK(Printer, printIt), TRUE, FALSE, CB_CI_DATA);
	setCallback(Activate, this, CBK(Printer, setup), TRUE, FALSE, CB_CI_DATA);
	registerMethod("drop", CBK(Printer, drop), "bool*");
};

extern "C" { unsigned int sleep(unsigned int); }

void Printer::printIt(ciClientData* cd)
{
	char* ptr = NULL;
	char** txt = &ptr;

	if(cd->operation == OP_ADD && cd->obj)
	{	getWorld()->refresh();
		cd->obj->msg("print", "char**", txt);
		for(int i = 0; i < copies; i++)
		{	cerr << "Printer: " << getName() << "\nprinting: " << cd->obj->getName();
			cerr << "(Copy No. " << i + 1 << ")\n\n";
			cerr << (*txt ? *txt : "Object not printable." ) << "\n\n";
		}
		sleep(2);
		cd->obj->msg("moveBack");
	}
}

void Printer::setup(void*)
{
	char* reply;

	if(reply = (new XmPrompter("Enter number of copies: ", "Configuration", "1", XmSmboxQuestion, getWorld()))->prompt())
	{	istrstream inp(reply);
		int newNo = 0;
		inp >> newNo;
		if(newNo < 1 || newNo > 10)
			newNo = 1;
		copies = newNo;
	}
}

void Printer::drop(void* qry)
{
	if(*((bool* )qry))
	{	ostrstream aMsg;
		aMsg << "Are you sure to drop\nthe tool " << getName() << "?"; aMsg.put('\0');
		if((new XmMsgBox(aMsg.str() , "Delete", XmSmboxQuestion, getWorld()))->showMsg())
			delete this;
	}
	else
		delete this;
}

Copier::Copier(char* n, int x, int y) : Printer(n, x, y, FALSE)
{
#ifdef TEST_COLORS
	lineColor("Orange")->fillColor("Green");
#endif
#ifdef TEST_IMAGES
	setImage(getRuntimeImage("icon2.gif"));
#endif
	setCallback(ChangeContents, this, CBK(Copier, copyIt), TRUE, FALSE, CB_CI_DATA);
}

void Copier::copyIt(ciClientData* cd)
{
	copyInfo* cinf = new copyInfo(copies);

	if(cd->operation == OP_ADD && cd->obj)
	{	getWorld()->refresh();
		cd->obj->msg("copy", "copyInfo*", cinf);
		int xy = 10;
		for(int i = 0; i < copies; i++)
		{	CiObject* anObj = cinf->copies[i];
			if(anObj)
			{	sleep(1);
				addChild(anObj, TRUE, FALSE);
				anObj->move(xy, xy);
				getWorld()->refresh();
				xy += 5;
				continue;
			}
			cerr << "Copier: paper jam!\n\n";
			break;
		}
		sleep(2);
		cd->obj->msg("moveBack");
	}
	delete cinf;
}

TrashCan::TrashCan(char* name, int x, int y) : CiObject(new Rectangle(x, y, 80, 100), name)
{
	setText(name);
#ifdef TEST_COLORS
	lineColor("Grey")->fillColor("Red");
#endif
#ifdef TEST_IMAGES
	setImage(getRuntimeImage("icon4.gif"));
#endif

	allowAssigningTo("TrashCan", NULL);
	allowAssignmentOf("doc*", "Printer", NULL);
	setCallback(ChangeContents, this, CBK(TrashCan, dropIt), TRUE, FALSE, CB_CI_DATA);
};

void TrashCan::dropIt(ciClientData* cd)
{
	bool reallyDrop = TRUE;

	if(cd->obj)
	{	getWorld()->refresh();
		cd->obj->msg("drop", "bool*", &reallyDrop);
		if(reallyDrop)
		{	removeChild(cd->obj, TRUE, FALSE);
			delete cd->obj;
		}
		else
			cd->obj->msg("moveBack");
	}
}

///////////////////////

void Desktop::showInfo(char* txt, int x, int y)
{
	if(!popupDoc)
		addChild(popupDoc = new CiObject(new Rectangle(x, y, 300, 30), "popup"));
	else
		popupDoc->move(x, y);
	popupDoc->setText(txt);
	popupDoc->show();
	refresh(TRUE);
}

bool Desktop::userClick(DrawPrim* p, int x, int y, bool sr)
{
	if(sr && p)
		return(XmCiWorld::userClick(p, x, y, sr));
	if(sr)
		cerr << "world - button down...\n";
	else
	{	if(!(buttonsPressed() & BUTTON(2)) && popupDoc)
		{	popupDoc->hide();
			refresh(TRUE);
		}
	}
	return(TRUE);
}

// the application window /////////////////////////////////////////

class TestWindow : public XmWindow
{
	XmCiWorld* world;

	bool initWindowSize(int&, int&, int& nw, int& nh)
		{ nw = 400; nh = 600; return(TRUE); } 
	void createCiWorld();
public:
	TestWindow();

	void myMenuItem(char*);
	void openNew(void*);
	void close(void*);

	void quit(void*);
};

void XmApp::initialize()
{
	(new TestWindow)->open();
};


TestWindow::TestWindow() : XmWindow("Test")
{
	XmDropdownMenu* m = createDropdownMenu();

	m->addLabel("&File");
	m->addLabel("&Edit");
	m->addLabel("&Misc");
	m->setCurrentLabel("File");
	m->addItem(Entry("&Open", (XmObject* )NULL, CBK(TestWindow, openNew)));
	m->addItem(Entry("&Close", (XmObject* )NULL, CBK(TestWindow, close)));
	m->addSeparator();
	m->addItem(Entry("E&xit", (XmObject* )NULL, CBK(TestWindow, quit)));

	createCiWorld();
}

void TestWindow::openNew(void*)
{
	(new TestWindow)->realize();
}

void TestWindow::close(void*)
{
	delete this;
}


void TestWindow::quit(void*)
{
	App->quit();
}


void TestWindow::createCiWorld()
{
	addSubpane(world = new Desktop("World", 10, 10, 400, 400));

	world->addChild(new Document("doc1", 10, 10));
	world->addChild(new Document("doc2", 20, 20));
	world->addChild(new Document("doc3", 30, 30));
	world->addChild(new Printer("Printer ", 40, 40));
	world->addChild(new Copier("Copier ", 50, 50));
	world->addChild(new TrashCan("Trash ", 60, 60));
}

