//
// ci2test.C  last changed Aug. 29, 1994
// Testing CommonInteract objects.
// This application should run under Motif and Xaw
//
// There are plans to add CommonInteract as an extension to TIP.
// Whether, and when this will be done depends on the author's  
// success with upcoming commercial TIP projects since it means a
// lot of work to implement the server functionality in non X
// GUI environments...
//

#include <iostream.h>
// define defaults to override before including the CI stuff
#define GPR_DEFAULT_FILL GPR_SOLID
#include "xmCi2.h"


class TestWindow : public XmWindow
{
	XmCiWorld* world;
	CiObject* theObject;

	void createCiWorld();
public:
	TestWindow();

	void reset(void*);
	void quit(void*);
};

void XmApp::initialize()
{
	(new TestWindow)->open();
};


TestWindow::TestWindow() : XmWindow("Test")
{
	setInitWindowSize(300, 300, 400, 600); 

	XmDropdownMenu* m = createDropdownMenu();

	m->addLabel("&File");
	m->addItem(Entry("&Reset", (XmObject* )NULL, CBK(TestWindow, reset)));
	m->addSeparator();
	m->addItem(Entry("E&xit", (XmObject* )NULL, CBK(TestWindow, quit)));

	createCiWorld();
}


void TestWindow::reset(void*)
{
	theObject->setPoints(5,
	        60, 100, 100, 140, 
	        140, 100, 100, 60, 60, 100);
	theObject->notifyChanges(Move);
	world->refresh(TRUE);
}

void TestWindow::quit(void*)
{
	App->quit();
}


void TestWindow::createCiWorld()
{
	CiObject* anObj, * it;

	addSubpane(world = new XmCiWorld("World", 10, 10, 400, 400));
/*
	anObj = new CiObject(
	    ((new Polygon())->setPoints(5,
	        60, 100, 100, 140, 
	        140, 100, 100, 60, 60, 100)), "Parent1");
*/
	anObj = new CiObject(
	    new Rectangle(10, 10, 100, 100), "Parent1");
	    anObj->fillColor("slate gray");	// GPR_BLACK);

	    anObj->fillPattern(GPR_SOLID);
	anObj->setText("Poly1");
	world->addChild(anObj);
	theObject = anObj;
/*
	anObj = new CiObject(
	    ((new Polygon())->setPoints(5,
	        80, 120, 120, 160, 
	        160, 120, 120, 80, 80, 120)), "Parent2");
*/
	anObj = new CiObject(
	    new Rectangle(100, 100, 100, 100), "Parent2");
	    anObj->fillColor("slate gray");	// GPR_BLACK);
	    anObj->fillPattern(GPR_SOLID);
	anObj->setText("Poly2");
	world->addChild(anObj);
	
	Connector* aConn = new Connector("Connector", CO_ARROW);
	aConn->allowFrom("Parent1", NULL);
	aConn->allowTo("Parent2", NULL);
	cerr << aConn->connect(theObject, anObj, CR_CENTER | CR_NEXT, CR_CENTER | CR_NEXT);
	world->refresh();
/*
	cerr << anObj->origin().x << "@" << anObj->origin().y << " / " <<
		anObj->extent().x << "@" << anObj->extent().y << "\n";
*/
}
