//
// phonebk.C  last changed Nov. 24, 1994
// A very simple phonebook program. Once you have a little
// expierience with Xm++, you may extend it in order to make
// it really useable.
//
// This application should run under Motif, Xaw and TIP
//

#include <xmObject.h>
#include <strstream.h>
#include <fstream.h>
#include <string.h>

#define MAXENTRIES 2000

// class declarations /////////////////////////////////////////////////

class PhoneEntry
{
friend class XmPhoneBook;
friend class PhoneDialog;
	char name[30];
	char firstName[20];
	char street[30];
	char zip[10];
	char city[20];
	char country[20];
	char phoneNo[15];
	bool isCompany;

	PhoneEntry();
	PhoneEntry(istream&);

	char* printString();
	void dumpOn(ostream&);
	int cmp(PhoneEntry*);
};

class PhoneDialog;

class XmPhoneBook : public XmDialogWindow
{
	PhoneEntry* entries[MAXENTRIES];
	int curEntry, entryCount;
	bool editNew;
	PhoneDialog* dlg;

	bool XmPhoneBook::initWindowSize(int& x, int& y, int& w, int& h)	{ w = 400; h = 400; return(TRUE); }

	void createMenu();

	void processEntry(char*);
	void resortCurEntry();
	void showMemoryUsage(void*);
	void testHide(void*);
	void openFile();
	void saveFile(void*);
	void sorry(char*);
	void quit(void*);
public:
	XmPhoneBook();

#ifdef __GNUG__ // bug in gcc < 2.6
	bool add(XmControl* c, XmObject* o = NULL, cbProc p = NULL, void* d = CB_OBJ_PTR)	{ return(XmDialogWindow::add(c, o, p, d)); }
	bool add(XmComboBox* c, XmObject* o = NULL, cbProc p = NULL, void* cd = CB_OBJ_PTR)	{ return(add((XmControl* )((void* )c), o, p, cd)); }
#endif

	void initialize();
	void updateCurEntry(bool);
};

class PhoneDialog : public XmUserDialog
{
	XmPhoneBook* phoneBook;
	PhoneEntry* entry;

	bool PhoneDialog::initWindowSize(int& x, int& y, int& w, int& h)	{ w = 580; h = 280; return(TRUE); }

	void initialize() { createContents(); initContents(); }

	void createContents();
	void initContents();

	void setEntryType(XmRadioButton*);
	void dlgOk(void*);
	void dlgCancel(void*);
public:
	PhoneDialog(XmPhoneBook* parent, PhoneEntry* e) : XmUserDialog("Phone Book Entry", parent, XmSdlgAppModal)
	{ phoneBook = parent; entry = e; }

	void setEntry(PhoneEntry*);
};

int alwaysNew;

// phonebook entry /////////////////////////////////////////////////

PhoneEntry::PhoneEntry()
{
	strcpy(name, "New.");
	*firstName = *street = *zip = *city = *country = *phoneNo = 0;
	isCompany = FALSE;
}

PhoneEntry::PhoneEntry(istream& in)
{
	int cmpflg;

	in.getline(name, 30);
	in.getline(firstName, 20);
	in.getline(street, 30);
	in.getline(zip, 10);
	in.getline(city, 20);
	in.getline(country, 20);
	in.getline(phoneNo, 15);
	in >> cmpflg >> ws;
	isCompany = cmpflg ? TRUE : FALSE;
}

char* _curEntryStr = NULL;

char* PhoneEntry::printString()
{
	delete _curEntryStr;

	ostrstream txt;
	txt 	<< name << " " << firstName
		<< " -> " << phoneNo;
	txt.put(0);
	return(_curEntryStr = txt.str());
}

void PhoneEntry::dumpOn(ostream& out)
{
	out 	<< name << "\n" << firstName << "\n"
		<< street << "\n" << zip << "\n"
		<< city << "\n" << country << "\n" 
		<< phoneNo << "\n" << isCompany << "\n";
}

int PhoneEntry::cmp(PhoneEntry* e)
{
	int val;

	if(	!(val = strcmp(name, e->name)) &&
		!(val = strcmp(firstName, e->firstName)) &&
		!(val = strcmp(country, e->country)) &&
		!(val = strcmp(city, e->city))	)
			val = strcmp(street, e->street);
	return(val);
}

// main window ///////////////////////////////////////////////////

XmPhoneBook::XmPhoneBook() : XmDialogWindow("Xm++ Phone Book")
{
	curEntry = -1;
	entryCount = 0;
	editNew = FALSE;
	dlg = NULL;
}

void XmPhoneBook::initialize()
{
	createMenu();
//	addSubpane(ListBox, "PhoneList");
	add(new XmListBox("PhoneList", 0, 0, 400, 400));
	listBox("PhoneList")->setDoubleClickCallback(this, CBK(XmPhoneBook, processEntry), TRUE, CB_OBJ_NAME);
	openFile();
}

void XmPhoneBook::createMenu()
{
	XmDropdownMenu* menu = createDropdownMenu();

	menu->addLabels("&File", "&Entry", "&Misc", NULL);

	menu->setCurrentLabel("File");
	menu->addItems(
	  Entry("&Open...", CBK(XmPhoneBook, sorry)), 
	  Entry("&Save", CBK(XmPhoneBook, saveFile)), 
	  Entry("&Print...", CBK(XmPhoneBook, sorry)),
	  Entry("Save &As...", CBK(XmPhoneBook, sorry)),
	  NULLENTRY);
	menu->addSeparator();
	menu->addItems(
	  Entry("E&xit", CBK(XmPhoneBook, quit)),
	  NULLENTRY);
	menu->setCurrentLabel("Entry");
	menu->addItems(
	  Entry("New", CBK(XmPhoneBook, processEntry)), 
	  Entry("Edit", CBK(XmPhoneBook, processEntry)), 
	  Entry("Delete", CBK(XmPhoneBook, processEntry)),
	  NULLENTRY);
	menu->setCurrentLabel("Misc");
	menu->addItems(
	  Entry("&Hide", CBK(XmPhoneBook, testHide)),
	  Entry("&Memory usage", CBK(XmPhoneBook, showMemoryUsage)),
	  NULLENTRY);
}

void XmPhoneBook::processEntry(char* cmd)
{
	PhoneEntry* anEntry;
	XmListBox* list = listBox("PhoneList");

	curEntry = -1;
	switch(*cmd)
	{	case 'N':
 		entries[entryCount++] = anEntry = new PhoneEntry;
		curEntry = entryCount;
		if(entryCount == 1)
			list->remove(1);
		list->add("New...");
		editNew = TRUE;

		case 'E':
		case 'P':
		if(curEntry < 0 && (curEntry = list->selectedIndex()) <= 0)
			break;
		if(!dlg || alwaysNew)
		{	(dlg = new PhoneDialog(this, entries[curEntry - 1]))->open();
		}
		else
		{	dlg->setEntry(entries[curEntry - 1]);
			dlg->show();
		}
		break;

		case 'D': {
		if((curEntry = list->selectedIndex()) <= 0)
			break;
		list->remove(curEntry);
		delete entries[curEntry - 1];
		for(int i = curEntry - 1; i < entryCount - 1; i++)
			entries[i] = entries[i + 1];
		entryCount--;
		curEntry = -1;
		if(!entryCount)
			list->add("No entries."); }
		break;
	}
}

void XmPhoneBook::updateCurEntry(bool ok)
{
	if(curEntry != -1)
	{	XmListBox* list = listBox("PhoneList");
		if(ok)
		{	PhoneEntry* anEntry = entries[curEntry - 1];
			list->remove(curEntry);
			resortCurEntry();
			list->insert(curEntry, anEntry->printString());
		}
		else
		{	if(editNew)
			{	list->selectIndex(curEntry);
				processEntry("Delete");
			}
		}
	}
	editNew = FALSE;
}

void XmPhoneBook::resortCurEntry()
{
	int i, curNdx = curEntry - 1;
	PhoneEntry* anEntry = entries[curNdx];

	entries[curEntry - 1] = NULL;
	for(i = curNdx; i < entryCount; i++)
		entries[i] = entries[i + 1];
	for(i = 0; i < entryCount - 1; i++)
	{	if(anEntry->cmp(entries[i]) <= 0)
		{	for(int j = entryCount; j > i; j--)
				entries[j] = entries[j - 1];
			entries[i] = anEntry;
			curEntry = i + 1;
			return;
		}
	}
	entries[entryCount - 1] = anEntry;
	curEntry = entryCount;
}

void XmPhoneBook::testHide(void*)
{
	hide();
	(new XmMsgBox("Click OK to show.", "Phonebook", XmSdlgAppModal | XmSmsgInfo | XmSmsgOk))->showMsg();
	show();
}

void XmPhoneBook::openFile()
{
	// add prompt for filename here...

	for(int i = 0; i < entryCount; i++)
		delete entries[i];
	entryCount = 0;

	ifstream in("phonebk.dat");
	char hdrbuf[20];
	PhoneEntry* anEntry;

	while(in.good())
	{	in.getline(hdrbuf, 20);
		if(strcmp(hdrbuf, "PHONE-ENTRY"))
			break;
		entries[entryCount++] = (anEntry = new PhoneEntry(in));
		listBox("PhoneList")->add(anEntry->printString());
	}
	if(!entryCount)
		listBox("PhoneList")->add("No entries.");
}

void XmPhoneBook::saveFile(void*)
{
	ofstream out("phonebk.dat");

	for(int i = 0; i < entryCount; i++)
	{	out << "PHONE-ENTRY\n";
		entries[i]->dumpOn(out);
	}
}

#include <malloc.h>

void XmPhoneBook::showMemoryUsage(void*)
{
	ostrstream msg;
#ifdef HP
	struct mallinfo mi = mallinfo();

	msg << "current memory usage: \n"
		<< " total: " << mi.arena << "\n"						/* total space in arena */
//		<< " no. ord. Blocks : " << mi.ordblks << " \n"			/* number of ordinary blocks */
//		<< " no. small Blocks : " << mi.smblks  << " \n"		/* number of small blocks */
//		<< " space hold Blk. Hdrs. : " << mi.hblkhd  << " \n"	/* space in holding block headers */
//		<< " no. hold. Blk. Hdrs. : " << mi.hblks  << " \n"		/* number of holding blocks */
//		<< " space small Blocks : " << mi.usmblks  << " \n"		/* space in small blocks in use */
//		<< " free small Blocks : " << mi.fsmblks  << " \n"		/* space in free small blocks */
		<< " space ord. Blocks : " << mi.uordblks  << " \n"		/* space in ordinary blocks in use */
		<< " free ord. Blocks : " << mi.fordblks  << " \n"		/* space in free ordinary blocks */
//		<< " space penality : " << mi.keepcost  << " \n"		/* space penalty if keep option */
;
#else
	msg << "Sorry, not available.";
#endif
	msg.put('\0');
	(new XmMsgBox(msg.str(), "System Info", XmSdlgAppModal | XmSmsgInfo | XmSmsgOk))->showMsg();
}

void XmPhoneBook::sorry(char* cmd)
{
	(new XmMsgBox("Sorry, not implemented.", cmd, XmSdlgAppModal | XmSmsgInfo | XmSmsgOk, this))->showMsg();
}

void XmPhoneBook::quit(void*)
{
	if((new XmMsgBox("Save file 'phonebk.dat'?", "Exit", XmSmboxQuestion, this))->showMsg())
		saveFile(NULL);
	if(!alwaysNew)
		delete dlg;
	delete this;
}

// phonebook entry dialog ////////////////////////////////////////////

// the createContents() method remained here only for historical reasons. :-)
// If you want to change the dialog, use the dialog editor, create a new one
// and #include it here (see the dlgbox example). But be sure to use exactly
// the control names you see below, your program will dump core otherwise...

void PhoneDialog::createContents()
{
	add((new XmGroupBox("prType", 14, 18, 150, 94))->setText("Type"));
	add((new XmRadioButton("ctrTypePerson", 38, 48, 88, 20))->setText("Person"));
	add((new XmRadioButton("ctrTypeCompany", 38, 72, 98, 20))->setText("Company"));
	add((new XmStaticText("prName", 206, 36, 52, 16, XmSright))->setText("Name"));
	add((new XmEdit("name", 268, 30, 282, 26, XmSautohscroll)));
	add((new XmStaticText("prFirstName", 172, 68, 78, 16, XmSright))->setText("First name"));
	add((new XmEdit("firstName", 268, 66, 224, 26, XmSautohscroll)));
	add((new XmStaticText("prStreet", 202, 104, 48, 16, XmSright))->setText("Street"));
	add((new XmEdit("street", 268, 100, 284, 26, XmSautohscroll)));
	add((new XmStaticText("prZip", 208, 144, 40, 16, XmSright))->setText("ZIP"));
	add((new XmEdit("zip", 268, 140, 64, 26, XmSautohscroll)));
	add((new XmStaticText("prCity", 350, 144, 34, 16))->setText("City"));
	add((new XmEdit("city", 390, 140, 164, 24, XmSautohscroll)));
	add((new XmStaticText("prCountry", 180, 186, 64, 16, XmSright))->setText("Country"));
	add((new XmComboBox("country", 268, 180, 286, 80)));
	add((new XmGroupBox("prPhone", 14, 126, 152, 80))->setText("Phone No."));
	add((new XmEdit("phone", 26, 166, 130, 26, XmSautohscroll)));
	add((new XmPushButton("ctrOk", 334, 230, 80, 30))->setText("OK"));
	add((new XmPushButton("ctrCancel", 436, 230, 80, 30))->setText("Cancel"));
}


void PhoneDialog::initContents()
{
	comboBox("country")->addAll("Austria", "Germany", "USA", NULL);

	radioButton("ctrTypePerson")->setCallback(this, CBK(PhoneDialog, setEntryType));
	radioButton("ctrTypeCompany")->setCallback(this, CBK(PhoneDialog, setEntryType));

	pushButton("ctrOk")->setCallback(this, CBK(PhoneDialog, dlgOk));
	pushButton("ctrCancel")->setCallback(this, CBK(PhoneDialog, dlgCancel));

	setEntry(entry);
}

void PhoneDialog::setEntryType(XmRadioButton* cmd)
{
	if(!strcmp(cmd->getName(), "ctrTypeCompany"))
	{	edit("firstName")->setText("");
		disable("prFirstName", "firstName", NULL);
	}
	else
		enable("prFirstName", "firstName", NULL);
}

void PhoneDialog::dlgOk(void*)
{

	strcpy(entry->name, edit("name")->getText());
	strcpy(entry->firstName, edit("firstName")->getText());
	strcpy(entry->street, edit("street")->getText());
	strcpy(entry->zip, edit("zip")->getText());
	strcpy(entry->city, edit("city")->getText());
	strcpy(entry->country, comboBox("country")->getText());
	strcpy(entry->phoneNo, edit("phone")->getText());
	entry->isCompany = radioButton("ctrTypeCompany")->getState();
	phoneBook->updateCurEntry(TRUE);

	if(alwaysNew)
		delete this;
	else
		hide();
}

void PhoneDialog::dlgCancel(void*)
{
	phoneBook->updateCurEntry(FALSE);
	if(alwaysNew)
		delete this;
	else
		hide();
}

void PhoneDialog::setEntry(PhoneEntry* e)
{
	entry = e;

	edit("name")->setText(entry->name);
	edit("firstName")->setText(entry->firstName);
	edit("street")->setText(entry->street);
	edit("zip")->setText(entry->zip);
	edit("city")->setText(entry->city);
	edit("phone")->setText(entry->phoneNo);
	comboBox("country")->setText(entry->country);

	char* bname = entry->isCompany ? "ctrTypeCompany" : "ctrTypePerson";
	XmRadioButton* aButton = radioButton(bname);
//#if !defined(HP) || defined(HP9)
	aButton->setState(TRUE);
//#endif
	setEntryType(aButton);
}

// application init function ////////////////////////////////////////////

void XmApp::initialize()
{
#ifdef RCI
	alwaysNew = 0;
#else
	alwaysNew = 1;
#endif
	if(getCmdArg(1))
		alwaysNew = (*getCmdArg(1) == 'n' ? 1 : 0);
	(new XmPhoneBook)->open();
};


