/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

// include string.h in gcc or windows.  extern C it everywhere except gcc.
#if defined(GCC)
#include <string.h>
#else
extern "C" {
#ifdef _MSC_VER
#include <string.h>
#else
#include <strings.h>
#endif
}
#endif

#include <am_inc.h>

#include STDVALUE__H
#include OBJECT__H

Am_WRAPPER_DATA_IMPL_ID (Am_Double, (value), Am_DOUBLE)

Am_Double_Data::operator== (Am_Double_Data& test_value) const
{
  return (this == &test_value) || ((double)test_value == value);
}

Am_Double_Data::operator double () const
{
  return value;
}

Am_Double_Data::Am_Double_Data (double in_value)
{
  value = in_value;
  refs = 1;
}

Am_WRAPPER_DATA_IMPL_ID (Am_String, (value), Am_STRING)

Am_String_Data::operator== (Am_String_Data& test_value) const
{
  return (this == &test_value) || !strcmp ((const char*)test_value, value);
}

Am_String_Data::operator== (const char* test_value) const
{
  return (value == test_value) || !strcmp (test_value, value);
}

Am_String_Data::operator const char* () const
{
  return value;
}

Am_String_Data::operator char* () const
{
  return (char*)value;
}

Am_String_Data::Am_String_Data (const char* in_value, bool copy)
{
  if (copy) {
    char* temp;
    temp = new char [strlen (in_value) + 1];
    strcpy (temp, in_value);
    value = temp;
  }
  else
    value = in_value;
  refs = 1;
}

Am_String_Data::~Am_String_Data ()
{
  delete (char*)value;
}

void Am_String_Data::Print_Name (ostream& out)
{
  out << (const char*)this;
}
