/****************************************************************************
** $Id: qstrvec.h,v 2.2 1997/08/06 15:05:55 hanord Exp $
**
** Definition of QStrVec and QStrIVec classes
**
** Created : 931203
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QSTRVEC_H
#define QSTRVEC_H

#include "qstring.h"
#include "qvector.h"
#include "qdstream.h"


#if defined(DEFAULT_TEMPLATECLASS)
typedef QVectorT<char>			QStrVecBase;
#else
typedef Q_DECLARE(QVectorM,char)		QStrVecBase;
#endif


class QStrVec : public QStrVecBase
{
public:
    QStrVec()  { dc = TRUE; }
    QStrVec( uint size, bool deepc = TRUE ) : QStrVecBase(size) {dc=deepc;}
   ~QStrVec()  { clear(); }
private:
    GCI	 newItem( GCI d )	{ return dc ? qstrdup( (const char*)d ) : d; }
    void deleteItem( GCI d )	{ if ( dc ) delete[] (char*)d; }
    int	 compareItems( GCI s1, GCI s2 )
				{ return strcmp((const char*)s1,
						(const char*)s2); }
    QDataStream &read( QDataStream &s, GCI &d )
				{ s >> (char *&)d; return s; }
    QDataStream &write( QDataStream &s, GCI d ) const
				{ return s << (const char *)d; }
    bool dc;
};


class QStrIVec : public QStrVec			// case insensitive string vec
{
public:
    QStrIVec() {}
    QStrIVec( uint size, bool dc = TRUE ) : QStrVec( size, dc ) {}
   ~QStrIVec() { clear(); }
private:
    int	 compareItems( GCI s1, GCI s2 )
				{ return stricmp((const char*)s1,
						 (const char*)s2); }
};


#endif // QSTRVEC_H
