// $Id: Dialog.h,v 1.7 1997/11/03 00:04:33 jharris Exp $
#ifndef Dialog_included
#define Dialog_included

#include <qapp.h>
#include <qdir.h>
#include <qtstream.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qpixmap.h>

#include "DlgObject.h"
#include "DlgParser.h"
#include "WidgetLayout.h"

class DialogWnd;

class Dialog : public DlgObject
{
    Q_OBJECT

    friend class DialogWnd;
    // Display class

    friend class DialogPropDialog;
    friend class DialogWindowPage;
    // property pages that needs access to the widget layout

public:
    Dialog( ProjectWnd &, const QString & );
    // ctor

    virtual ~Dialog();
    // dtor

    virtual void SetName( const QString &, bool = TRUE );
    // Set name

    /* Methods which must be implemented from DlgObject
     */

    virtual QString GetType();
    virtual DlgObjectType GetObjType();
    
    const QString &GetDlgName() const;
    // Return the Dlg File name
    
    void SetDlgName( const QString & );
    // Set the Dlg File name

    void SetCaption( const QString& caption );

    QString GetCaption( void ) const;

    QString GetClassName( void ) const;
    
    void SetClassName( const QString& className );
    
    QString GetClassHeader( void ) const;
    
    void SetClassHeader( const QString& classHeader );
    
    QString GetClassSource( void ) const;
    
    void SetClassSource( const QString& classSource );

    QString GetDataName( void ) const;
    
    void SetDataName( const QString& dataName );
    
    QString GetDataHeader( void ) const;
    
    void SetDataHeader( const QString& dataHeader );
    
    QString GetDataSource( void ) const;
    
    void SetDataSource( const QString& dataSource );

    QString GetDataVariableName( void ) const;
    
    void SetDataVariableName( const QString& dataName );
    
    enum WindowType
    {
	WT_Dialog,
	WT_TabDialog,
	WT_Widget,
	WT_Frame,
	WT_Custom
    };

    void SetWindowType( WindowType type );
    
    WindowType GetWindowType( void ) const;

    const QString GetWindowStr( void ) const;

    const QString GetWindowHeader( void ) const;
    
    void SetIsDialogModal( bool modal );
    
    bool IsDialogModal( void ) const;

    void SetCustomBase( const QString &, const QString & );
  
    void GetCustomBase( QString &, QString & );

    void GetGeneratedFiles( QString &, QString &, QString & );

    WFlags GetWindowFlags( void ) const;
    void SetWindowFlags( WFlags	flags );
    // get/set methods on the window flags

    QSize GetWindowSize( void ) const;
    void SetWindowSize( const QSize&	theSize );
    // Get/Set methods on the window's size

    const QSize& GetWindowMinSize( void ) const;
    void SetWindowMinSize( const QSize&	theSize );
    // Get/Set methods on the window's min size

    const QSize& GetWindowMaxSize( void ) const;
    void SetWindowMaxSize( const QSize&	theSize );
    // Get/Set methods on the window's max size

    const QPoint& GetWindowPos( void ) const;
    void SetWindowPos( const QPoint&	thePoint );
    // Get/Set methods on the window's initial position
    
public slots:
    virtual bool Load( );
    // Load from disk

    virtual bool Save( );
    // Save to disk

    virtual bool Generate( bool = TRUE );
    // Generate c++ files

    virtual void Hide();
    // Hide from screen

    virtual void Show();
    // Show (again)

    virtual void Raise();
    // Raise window

    virtual bool EnterProject( const Project * );
    // Added in a project, remember this project

    virtual bool LeaveProject( const Project * );
    // Removed from a Project, forget this project

    virtual void CPAvailable( bool );
    // Somehow c&p data was made available

    void CutSelectedWidgets();
    void CopySelectedWidgets();
    void PasteSelectedWidgets();
    void LayoutChanged();

private slots:
    void RestoreDialog( QString &key, QString &value );
    // Restores dialog wide data

    void RestoreLayout();
    // Start to restore a Layout

private: // Methods
    void GenerateSource( void );
    // generate the source files for the dialog class

    void GenerateSourceHeader( QTextStream&	stream );
    // generate the source for the header of the dialog class

    void GenerateSourceSource( QTextStream&	stream );
    // generate the source for the source of the dialog class

    void GenerateData( void );
    // generate the source files for the dialog data class

    void OutputDlgeditHeader
    (
	QTextStream&	stream,
	const QString&	filename,
	bool		editWarning
    );
    // output a header comment block saying that this file was generated
    // by qtarch. if editWarning is true, output a message saying that this
    // file should not be edited.

private: // Attributes
    DialogWnd *itsWindow;
    // DialogWnd is the displaying class

    WidgetLayout *itsLayout;
    // DialogWnd is the displaying class

    QString	itsCaption;
    // caption for the window

    QString	itsClassName;
    // name of the dialog class

    QString	itsClassHeader;
    // header filename for the class

    QString	itsClassSource;
    // source filename for the class

    QString	itsDataName;
    // name of the dialog data class

    QString	itsDataHeader;
    // header filename for the data class

    QString	itsDataSource;
    // source filename for the data class

    QString	itsDataVariableName;
    // member variable name for the dialog data

    WindowType	itsWindowType;
    // base class for the window

    bool	isDialogModal;
    // is the dialog modal if its derived from QDialog

    QString itsCustomBase;
    QString itsCustomBaseHeader;
    // Class and its header if base is custom

    WFlags	itsWindowFlags;
    // Widget style flags for the window
};

inline QString Dialog::GetType()
{
  return "Dialog";
}

inline DlgObjectType Dialog::GetObjType()
{
  return DlgObject_Dialog;
}

inline void Dialog::SetCaption( const QString& caption )
{
    itsCaption = caption;
}


inline QString Dialog::GetCaption( void ) const
{
    return itsCaption;
}

inline QString Dialog::GetClassName( void ) const
{
    return itsClassName;
}
    
inline void Dialog::SetClassName( const QString& className )
{
    itsClassName = className;
}

    
inline QString Dialog::GetClassHeader( void ) const
{
    return itsClassHeader;
}

    
inline void Dialog::SetClassHeader( const QString& classHeader )
{
    itsClassHeader = classHeader;
}

    
inline QString Dialog::GetClassSource( void ) const
{
    return itsClassSource;
}

    
inline void Dialog::SetClassSource( const QString& classSource )
{
    itsClassSource = classSource;
}


inline QString Dialog::GetDataName( void ) const
{
    return itsDataName;
}

    
inline void Dialog::SetDataName( const QString& dataName )
{
    itsDataName = dataName;
}

    
inline QString Dialog::GetDataHeader( void ) const
{
    return itsDataHeader;
}


inline void Dialog::SetDataHeader( const QString& dataHeader )
{
    itsDataHeader = dataHeader;
}

    
inline QString Dialog::GetDataSource( void ) const
{
    return itsDataSource;
}

    
inline void Dialog::SetDataSource( const QString& dataSource )
{
    itsDataSource = dataSource;
}


inline QString Dialog::GetDataVariableName( void ) const
{
    return itsDataVariableName;
}

    
inline void Dialog::SetDataVariableName( const QString& dataName )
{
    itsDataVariableName = dataName;
}
    
inline void Dialog::SetWindowType( WindowType type )
{
    itsWindowType = type;
}


inline Dialog::WindowType Dialog::GetWindowType( void ) const
{
    return itsWindowType;
}


inline void Dialog::SetIsDialogModal( bool modal )
{
    isDialogModal = modal;
}


inline bool Dialog::IsDialogModal( void ) const
{
    return isDialogModal;
}
 
inline void Dialog::SetCustomBase( const QString &c, const QString &h )
{
  itsCustomBase = c;
  itsCustomBaseHeader = h;
}
 
inline void Dialog::GetCustomBase( QString &c, QString &h )
{
  c = itsCustomBase;
  h = itsCustomBaseHeader;
}
 
inline WFlags Dialog::GetWindowFlags( void ) const
{
    return itsWindowFlags;
}


inline void Dialog::SetWindowFlags( WFlags	flags )
{
    itsWindowFlags = flags;
}


inline QSize Dialog::GetWindowSize( void ) const
{
    return itsLayout->GetWindowSize();
}


inline void Dialog::SetWindowSize( const QSize&	theSize )
{
    itsLayout->SetWindowSize( theSize );
}


inline const QSize& Dialog::GetWindowMinSize( void ) const
{
    return itsLayout->GetWindowMinSize();
}


inline void Dialog::SetWindowMinSize( const QSize&	theSize )
{
    itsLayout->SetWindowMinSize( theSize );
}


inline const QSize& Dialog::GetWindowMaxSize( void ) const
{
    return itsLayout->GetWindowMaxSize();
}


inline void Dialog::SetWindowMaxSize( const QSize&	theSize )
{
    itsLayout->SetWindowMaxSize( theSize );
}


inline const QPoint& Dialog::GetWindowPos( void ) const
{
    return itsLayout->GetWindowPos();
}


inline void Dialog::SetWindowPos( const QPoint&	thePoint )
{
    itsLayout->SetWindowPos( thePoint );
}
    

#endif
