// $Id: DialogWnd.h,v 1.8 1997/11/03 00:04:34 jharris Exp $

#ifndef DialogWnd_included
#define DialogWnd_included

#include <qaccel.h>
#include <qframe.h>
#include <qmenubar.h>
#include <qstring.h>
#include <qlayout.h>

#include "WidgetLayout.h"
#include "WidgetFrame.h"
#include "Toolbar.h"
#include "StatusBar.h"

class Dialog;
class DlgParser;
class ProjectWnd;

class DialogWnd : public QFrame
{
    Q_OBJECT

public:
    DialogWnd
    ( 
	Dialog*,
	ProjectWnd *,
	const char* name = NULL 
    );

    virtual ~DialogWnd();

    int DoPropertyDialog( void );
    // show the property dialog

    WidgetLayout *GetLayout();
      
    void CPAvailable( bool );
    // C&P data available or not

    void SetCaption
    (
	const QString&	captionStr
    );
    // Set the caption on the window and the layout window


public slots:

    void Close();
    // close window

    void UpdateScreen( int flags );
    // Update the menus and toolbars according to the flags given.  If the 
    // flag is present, the item is enabled

signals:

    void Closed();
        
private: // methods

    void resizeEvent
    (
	QResizeEvent*	event
    );

    void closeEvent
    (
	QCloseEvent*	event
    );

    void ResetContents( void );
    // clear and reset the dialog

private slots:
         
    void NewButton();
    void NewButtonGroup();
    void NewCheckBox();
    void NewComboBox();
    void NewFrame();
    void NewGroupBox();
    void NewLCDNumber();
    void NewLabel();
    void NewLineEdit();
    void NewListBox();
    void NewMenuBar();
    void NewMultiLineEdit();
    void NewProgressBar();
    void NewPushButton();
    void NewRadioButton();
    void NewScrollBar();
    void NewSlider();
    void NewUser();

    void WidgetWndChanged();

    void WidgetGeometryChanged( int, int, int, int );

    void WidgetSelected( const QString& widgetName, 
			 const QString& varName );
  void WidgetDeselected();

    void ShowToolTip( const char* );
    void RemoveToolTip();

private: // attributes

    QBoxLayout	itsLayout;
    // geometry layout manager

    QMenuBar		itsMenu;
    // the menu

    WidgetFrame* itsActWidgetWnd;
    // frame to hold the widgets

    WidgetLayout*	itsActLayout;
    // handles the layout of widgets on the window

    Toolbar	itsToolbar;
    // toolbar for the window

    Toolbar	itsWidgetToolbar;
    // toolbar for widgets

    StatusBar	itsStatusBar;
    // status bar of the window

    uint	itsStatusMsg;
    uint	itsStatusPos;
    uint	itsStatusSize;
    // identifiers for status bar regions

    QString	itsLastStatusMsg;
    // the last status message that was not a tool tip

    QPopupMenu *itsEditMenu;
    // Have to remember it, because we want to disable items inside
          
    int cutMenuId, copyMenuId, pasteMenuId;
    // Menu ids

    int itsAlignMenuId;
    int	itsAlignTopMenuId;
    int	itsAlignBottomMenuId;
    int	itsAlignLeftMenuId;
    int itsAlignRightMenuId;
    int itsAlignWidthMenuId;
    int itsAlignHeightMenuId;
    int	itsAlignSizeMenuId;
    int itsEditRaiseMenuId;
    int itsEditLowerMenuId;
    int itsEditDeleteMenuId;
    int itsEditSizeToFitMenuId;
    int itsLayoutBoxLayoutMenuId;
    int itsLayoutGridLayoutMenuId;
    int itsLayoutSpacingMenuId;
    int itsLayoutStretchMenuId;
    // More menu ids

    uint itsCutTbId;
    uint itsCopyTbId;
    uint itsPasteTbId;
    uint itsAlignTopTbId;
    uint itsAlignBottomTbId;
    uint itsAlignLeftTbId;
    uint itsAlignRightTbId;
    uint itsAlignWidthTbId;
    uint itsAlignHeightTbId;
    uint itsAlignSizeTbId;
    uint itsLayoutBoxLayoutTbId;
    uint itsLayoutGridLayoutTbId;
    uint itsLayoutSpacingTbId;
    uint itsLayoutStretchTbId;
    // Toolbar ids
 
    QAccel	itsKbdAccel;
    // keyboard accelerator handlers

    ProjectWnd *theProjectWnd;
    // The application

    Dialog *itsDialog;
    // Its master class
};

    
typedef QList<DialogWnd> DlgList;


inline WidgetLayout *DialogWnd::GetLayout()
{
    return itsActLayout;
}


inline void DialogWnd::SetCaption
(
    const QString&	captionStr
)
{
    setCaption( "Qt Architect : " + captionStr );
    setIconText( caption() );
}


#endif // DialogWnd_included


