// $Id: GenerateDialog.cpp,v 1.2 1997/04/17 03:19:45 jharris Exp $

#include <qfile.h>
#include <qpushbt.h>
#include <qmsgbox.h>
#include <qlabel.h>

#include "GenerateDialog.h"

#define Inherited QDialog

GenerateDialog::GenerateDialog
(
    const QString&	fileName,
    const QString&	dlgClassName,
    const QString&	classHeader,
    const QString&	classSource,
    const QString&	dataHeader,
    const QString&	dataSource,
    QWidget*		parent,
    const char*		name
)
    :
    Inherited( parent, name, TRUE ),
    itsSourceCheckbox( "Generate dialog class files", this ),
    itsSourceGB( "Filenames...", this ),
    itsClassHeaderLabel( "Source:", this ),
    itsClassSourceLabel( "Header:", this ),
    itsClassHeaderEdit( this ),
    itsClassSourceEdit( this ),
    itsDataCheckbox( "Generate dialog data class files", this ),
    itsDataGB( "Filenames...", this ),
    itsDataHeaderLabel( "Source:", this ),
    itsDataSourceLabel( "Header:", this ),
    itsDataHeaderEdit( this ), 
    itsDataSourceEdit( this )
{
    setCaption( "Generate Source" );

    QLabel* label = new QLabel( "Dialog file: " + fileName, this );
    label->adjustSize();
    label->move( 20, 10 );
    
    label = new QLabel("Dialog class: " + dlgClassName, this );
    label->adjustSize();
    label->move( 20, 25 );

    itsSourceCheckbox.setGeometry( 20, 40, 190, 30 );
    itsSourceGB.setGeometry( 40, 70, 330, 50 );
    itsClassHeaderLabel.setGeometry( 50, 85, 50, 30 );
    itsClassSourceLabel.setGeometry( 215, 85, 40, 30 );
    itsClassHeaderEdit.setGeometry( 100, 90, 100, 20 );
    itsClassSourceEdit.setGeometry( 260, 90, 100, 20 );
    itsDataCheckbox.setGeometry( 20, 125, 220, 30 );
    itsDataGB.setGeometry( 40, 155, 330, 50 );
    itsDataHeaderLabel.setGeometry( 50, 170, 50, 30 );
    itsDataSourceLabel.setGeometry( 215, 170, 40, 30 );
    itsDataHeaderEdit.setGeometry( 100, 175, 100, 20 );
    itsDataSourceEdit.setGeometry( 260, 175, 100, 20 );

    itsClassHeaderEdit.setText( classHeader );
    itsClassSourceEdit.setText( classSource );
    itsDataHeaderEdit.setText( dataHeader );
    itsDataSourceEdit.setText( dataSource );

    bool checked = 
	(classHeader.isEmpty() || !QFile::exists( classHeader )) &&
	(classSource.isEmpty() || !QFile::exists( classSource ));

    itsSourceCheckbox.setChecked( checked );
    connect( &itsSourceCheckbox, SIGNAL(toggled(bool)), 
             SLOT(GetSourceNames(bool)) );
    GetSourceNames( checked );

    itsDataCheckbox.setChecked( TRUE );
    connect( &itsDataCheckbox, SIGNAL(toggled(bool)), 
             SLOT(GetDataNames(bool)) );
    GetDataNames( TRUE );
    
    QPushButton* button = new QPushButton( "Generate", this );
    button->setGeometry( 20, 215, 100, 30 );
    connect( button, SIGNAL(clicked()), SLOT(EndDialog()) );
    
    button = new QPushButton( "Cancel", this );
    button->setGeometry( 280, 215, 100, 30 );
    connect( button, SIGNAL(clicked()), SLOT(reject()) );

    adjustSize();
}

bool GenerateDialog::GenerateSource( QString &header, QString &source )
{
  bool ret = itsSourceCheckbox.isChecked();
  if( ret )
  {
    header = itsClassHeaderEdit.text();
    source = itsClassSourceEdit.text();
  }
  return ret; 
}

bool GenerateDialog::GenerateData( QString &header, QString &source )
{
  bool ret = itsDataCheckbox.isChecked();
  if( ret )
  {
    header = itsDataHeaderEdit.text();
    source = itsDataSourceEdit.text();
  }
  return ret; 
}

/* Slot called by itsSourceCheckbox whenever its Status changed
 *
 * Display the LineEdits for the Source names when Checkbox is on
 */
void GenerateDialog::GetSourceNames( bool on )
{
    itsSourceGB.setEnabled( on );
    itsClassHeaderLabel.setEnabled( on );
    itsClassSourceLabel.setEnabled( on );
    itsClassHeaderEdit.setEnabled( on );
    itsClassSourceEdit.setEnabled( on );
}

/* Slot called by itsDataCheckbox whenever its Status changed
 *
 * Display the LineEdits for the Data names when Checkbox is on
 */
void GenerateDialog::GetDataNames( bool on )
{
    itsDataGB.setEnabled( on );
    itsDataHeaderLabel.setEnabled( on );
    itsDataSourceLabel.setEnabled( on );
    itsDataHeaderEdit.setEnabled( on );
    itsDataSourceEdit.setEnabled( on );
}

/* Slot called by the OK-Button
 *
 * Check wether all LineEdits which are visible have a text
 * If so, end the dialog with accept, otherwise bring up a messagebox
 * which explains the horrible error which was made by the user...
 */
void GenerateDialog::EndDialog()
{
  QString sC, hC;
  QString sD, hD;

  int errorCode = 0;

  if( itsSourceCheckbox.isChecked() )
  {
    hC = itsClassHeaderEdit.text();
    sC = itsClassSourceEdit.text();
  }

  if( itsDataCheckbox.isChecked() )
  {
    hD = itsDataHeaderEdit.text();
    sD = itsDataSourceEdit.text();
  }

  if( itsSourceCheckbox.isChecked() )
  {
    if( sC == "" )
      errorCode |= 1;
    if( hC == "" )
      errorCode |= 2;
  }
  if( itsDataCheckbox.isChecked() )
  {
    if( sD == "" )
      errorCode |= 4;
    if( hD == "" )
      errorCode |= 8;
  }

  // Some of the following error conditions are, mh, absurd
  QString errorText;
  switch( errorCode )
  {
  case 0:
    accept();
    break;
  case 1:
    errorText = "No file for the class header specified";
    break;
  case 2:
    errorText = "No file for the class source specified";
    break;
  case 3:
    errorText = "No files for the class specified";
    break;
  case 4:
    errorText = "No file for the data header specified";
    break;
  case 5:
    errorText = "No file for the headers specified";
    break;
  case 6:
    errorText = "No file for the class source and the data header specified";
    break;
  case 7:
    errorText = "No file for the class and the data header specified";
    break;
  case 8:
    errorText = "No file for the data source specified";
    break;
  case 9:
    errorText = "No file for the class header and data source specified";
    break;
  case 10:
    errorText = "No files for the sources specified";
    break;
  case 11:
    errorText = "No files for the class and the data source specified";
    break;
  case 12:
    errorText = "No files for the data specified";
    break;
  case 13:
    errorText = "No files for the class header and the data specified";
    break;
  case 14:
    errorText = "No files for the class source and the data specified";
    break;
  case 15:
    errorText = "No files specified";
    break;
  }

  QMessageBox::message( "Error...",
                        errorText,
                        "Try again",
                        this );

}












