%{
#include <qstring.h>
#include <qregexp.h>
#include "DlgParser.h"
%}

CHARS [A-Za-z_]
WORD {CHARS}({CHARS}|[0-9]|"-"|".")*
NUMBER [0-9]+
WIDGETS_A Button|ButtonGroup|CheckBox|ComboBox|Frame|GroupBox
WIDGETS_B LCDNumber|Label|LineEdit|ListBox|MenuBar|PushButton
WIDGETS_C RadioButton|ScrollBar|MultiLineEdit|User|Slider|ProgressBar
WIDGETLAYOUT    WidgetLayout
PROJECT   Project
DIALOG    Dialog
PIXMAP    Pixmap
WIDGETS {WIDGETS_A}|{WIDGETS_B}|{WIDGETS_C}
ID {NUMBER}("."{NUMBER})*
LAYOUTITEMS Box_Layout-{ID}|Box_Stretch-{ID}|Box_Spacing-{ID}|Box_Widget-{ID}
%x InsideLayout
%x InsideWidget
%x InsideDialog
%x InsideProject
%x InsideLayoutItem
%x InsidePixmap

%%
%{
%}

<*>[ \t]*  /* Whitespaces are ignored */
<*>\n { 
  if( gDlgParser )
    gDlgParser->lineNumber++; 
}

{PROJECT} {
  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  // Not really a widget, but handled as one for now
  BEGIN(InsideProject);

  return (int) ProjectDataStart;
}

{DIALOG} { 
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  // Not really a widget, but handled as one for now
  BEGIN(InsideDialog);

  return (int) DialogDataStart;
}

{WIDGETLAYOUT} { 
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  BEGIN(InsideLayout);

  return (int) LayoutDataStart;
}

{PIXMAP} { 
  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  BEGIN(InsidePixmap);

  return (int) PixmapDataStart;
}

<InsideLayout>{WIDGETS} { 
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  BEGIN(InsideWidget);

  return (int) WidgetDataStart;
}

<InsideLayout>{LAYOUTITEMS} {
  if( gDlgParser )
    gDlgParser->widgetType = yytext;

  // Skipping Whitespaces up to (and including) opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );

  BEGIN(InsideLayoutItem);

  return (int) LayoutItemDataStart;
}

\{ { 
  fprintf( stderr, "Error in line %d\n", gDlgParser->lineNumber );
  if( gDlgParser )
    gDlgParser->errorCount++;
  return (int) ErrorInInput;
}

<InsidePixmap>\} {
  BEGIN(0);
  return (int) PixmapDataEnd;
}

<InsideWidget>\} {
  BEGIN(InsideLayout);
  return (int) WidgetDataEnd;
}

<InsideLayoutItem>\} {
  BEGIN(InsideLayout);
  return (int) LayoutItemDataEnd;
}

<InsideLayout>\} {
  BEGIN(0);
  return (int) LayoutDataEnd;
}

<InsideDialog>\} {
  BEGIN(0);
  return (int) DialogDataEnd;
}

<InsideProject>\} {
  BEGIN(0);
  return (int) ProjectDataEnd;
}

<*>{WORD} {
  if( gDlgParser )
    gDlgParser->key = yytext;

  // Skipping Whitespaces up to opening bracket
  int c;
  while( (c = yyinput()) != '{' && c != EOF );
  unput( c );
}

<*>\{[^}]*\} {
  QString str( yytext );
  // Removing tabs and newlines
  str.replace( QRegExp( "\n" ), " " );
  str.replace( QRegExp( "\t" ), " " );

  // Removing leading and trailing curly bracket
  str = str.mid( 1, str.length() - 2 );

  if( gDlgParser )
    gDlgParser->value = str;

  int retVal;
  switch( YY_START )
  {  
case InsideDialog : retVal = (int) DialogData; break;
case InsideLayout : retVal = (int) LayoutData; break;
case InsideWidget : retVal = (int) WidgetData; break;
case InsideProject: retVal = (int) ProjectData; break;
case InsideLayoutItem: retVal = (int) LayoutItemData; break;
case InsidePixmap : retVal = (int) PixmapData; break;
default          : retVal = (int) ErrorInInput; break;
  }
  return retVal;
}

%%






