#ifndef BoxWidget_included
#define BoxWidget_included

#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>

#include "layout/LayoutItem.h"

class DlgWidget;

class BoxWidget : public LayoutItem
{
public: // Methods

    BoxWidget
    (
	QWidget*	parent,
	DlgWidget*	widget,
	WidgetLayout*	layout,
	int		stretch = 1,
	int		alignment = AlignCenter
    );
    
    virtual ~BoxWidget();
    
    virtual void AddToLayout
    (
	QBoxLayout*	layout
    );
    // Add the item to the layout

    virtual LayoutItem* FindLayoutItem
    (
	QWidget*	widget
    ) const;
    // Given the widget representing a layout item, return the item or NULL if
    // not found

    virtual void SaveContents( QTextStream&	stream,
			       QString		id ) const;
    // Save the item's contents to the stream with the given id

    virtual bool RestoreKeyValue( const QString&	key,
				  const QString&	value );
    // Restore a single key/value pair

    virtual void GenerateSource( QTextStream&	stream,
				 const QString&	layoutVarName,
				 const QString&	layoutId ) const;
    // Generate the source for the layout given by layoutVarName.  If the 
    // layoutVarName is empty, the layout is a top level layout

    static QString ItemName( void );
    // Static method to return the name of this item

    virtual QString GetItemName( void ) const;
    // Return a text string for the name of this item

    virtual QRect GetGlobalGeometry( void ) const;
    // Get the global geometry for this layout item

    void DeleteSelf( void );
    // Remove itself from its layout's list, which will cause it to be deleted

    int GetStretch( void ) const;
    
    void SetStretch
    (
	int	stetch
    );
    // Get/Set methods on the amount of stretch

    int GetAlignment( void ) const;
    
    void SetAlignment
    (
	int	alignment
    );
    // Get/Set methods on the alignment


private: // Methods

    BoxWidget();
    BoxWidget( const BoxWidget& );
    BoxWidget& operator= ( const BoxWidget& );

private: // Attributes

    DlgWidget*	itsWidget;
    // the widget this class represents

    QWidget*	itsParent;
    // the parent widget of the box widget

    int		itsStretch;
    // amount of stretch for the widget

    int		itsAlignment;
    // the widget's alignment
};


inline QString BoxWidget::ItemName( void )
{
    return "Box_Widget";
}


inline int BoxWidget::GetStretch( void ) const
{
    return itsStretch;
}


inline void BoxWidget::SetStretch
(
    int	stretch
)
{
    itsStretch = stretch;
}


inline int BoxWidget::GetAlignment( void ) const
{
    return itsAlignment;
}


inline void BoxWidget::SetAlignment
(
    int	alignment
)
{
    itsAlignment = alignment;
}



#endif // BoxWidget_included
