#include <qbttngrp.h>

#include "ButtonGroupPage.h"

#include "widget/DlgWidget.h"

#define Inherited ButtonGroupPageData

ButtonGroupPage::ButtonGroupPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QButtonGroup* group = (QButtonGroup*)widget->GetWidget();
    
    itsTitle->setText( group->title() );
    
    switch( group->alignment() & (AlignLeft | AlignRight | AlignHCenter) )
    {
	case AlignLeft:
	default:
	{
	    isTitleLeft->setChecked( TRUE );
	    break;
	}
	case AlignHCenter:
	{
	    isTitleCenter->setChecked( TRUE );
	    break;
	}
	case AlignRight:
	{
	    isTitleRight->setChecked( TRUE );
	    break;
	}
    }

    isExclusive->setChecked( group->isExclusive() );
}


ButtonGroupPage::~ButtonGroupPage()
{
}


void ButtonGroupPage::Apply( DlgWidget*	widget )
{
    QButtonGroup* group = (QButtonGroup*)widget->GetWidget();
    
    group->setTitle( itsTitle->text() );
    
    int alignment = AlignLeft;	// default

    if( isTitleCenter->isChecked() )
    {
	alignment = AlignHCenter;
    }
    else if( isTitleRight->isChecked() )
    {
	alignment = AlignRight;
    }

    group->setAlignment( alignment );

    group->setExclusive( isExclusive->isChecked() );
}

