#include "DialogBasePage.h"

#include "Dialog.h"
#include "DialogWnd.h"

#define Inherited DialogBasePageData

DialogBasePage::DialogBasePage
(
 Dialog* dialog,
 QWidget* parent,
 const char* name
 )
  :
  Inherited( parent, name )
{
  switch( dialog->GetWindowType() )
  {
	case Dialog::WT_Dialog:
    {
	    isQDialog->setChecked( TRUE );
	    break;
    }
	case Dialog::WT_TabDialog:
    {
	    isQTabDialog->setChecked( TRUE );
	    break;
    }
	case Dialog::WT_Widget:
    {
	    isQWidget->setChecked( TRUE );
	    break;
    }
	case Dialog::WT_Frame:
    {
	    isQFrame->setChecked( TRUE );
	    break;
    }
  case Dialog::WT_Custom:
    {
	    isCustom->setChecked( TRUE );
	    break;
    }
  }
    
  isModalDialog->setChecked( dialog->IsDialogModal() );
  QString cl, clHdr;

  dialog->GetCustomBase( cl, clHdr );
    
  customClass->setText( cl );
  customClassHeader->setText( clHdr );
    
  if( isCustom->isChecked() )
  {
    customClass->setEnabled( TRUE );
    customClassHeader->setEnabled( TRUE );
  } else
  {
    customClass->setEnabled( FALSE );
    customClassHeader->setEnabled( FALSE );
  }
}


DialogBasePage::~DialogBasePage()
{
}

void DialogBasePage::UseCustom( bool useIt )
{
  customClass->setEnabled( useIt );
  customClassHeader->setEnabled( useIt );
}

void DialogBasePage::Apply( Dialog* dialog )
{
    Dialog::WindowType type = Dialog::WT_Dialog;
    
    if( isQTabDialog->isChecked() )
    {
	type = Dialog::WT_TabDialog;
    }
    else if( isQWidget->isChecked() )
    {
	type = Dialog::WT_Widget;
    }
    else if( isQFrame->isChecked() )
    {
	type = Dialog::WT_Frame;
    }
    else if( isCustom->isChecked() )
    {
	type = Dialog::WT_Custom;
    }
    
    dialog->SetWindowType( type );
    
    dialog->SetIsDialogModal( isModalDialog->isChecked() );

    dialog->SetCustomBase( customClass->text(), customClassHeader->text() );
}
