#include <qlcdnum.h>
#include <qstring.h>

#include "LCDNumberPage.h"

#include "widget/DlgWidget.h"

#define Inherited LCDNumberPageData

LCDNumberPage::LCDNumberPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QLCDNumber* num = (QLCDNumber*)widget->GetWidget();
    QString str;
    
    switch( num->mode() )
    {
	case QLCDNumber::HEX:
	{
	    isModeHex->setChecked( TRUE );
	    break;
	}
	case QLCDNumber::DEC:
	{
	    isModeDecimal->setChecked( TRUE );
	    break;
	}
	case QLCDNumber::OCT:
	{
	    isModeOctal->setChecked( TRUE );
	    break;
	}
	case QLCDNumber::BIN:
	{
	    isModeBinary->setChecked( TRUE );
	    break;
	}
    }

    switch( num->segmentStyle() )
    {
	case QLCDNumber::Outline:
	{
	    isSegmentOutline->setChecked( TRUE );
	    break;
	}
	case QLCDNumber::Filled:
	{
	    isSegmentFilled->setChecked( TRUE );
	    break;
	}
	case QLCDNumber::Flat:
	{
	    isSegmentFilled->setChecked( TRUE );
	    break;
	}
    }

    str.setNum( num->numDigits() );
    itsNumDigits->setText( str );
    isSmallPoint->setChecked( num->smallDecimalPoint() );
}


LCDNumberPage::~LCDNumberPage()
{
}


void LCDNumberPage::Apply( DlgWidget*	widget )
{
    QLCDNumber* num = (QLCDNumber*)widget->GetWidget();
    
    QLCDNumber::Mode mode = QLCDNumber::DEC;

    if( isModeHex->isChecked() )
    {
	mode = QLCDNumber::HEX;
    }
    else if( isModeOctal->isChecked() )
    {
	mode = QLCDNumber::OCT;
    }
    else if( isModeBinary->isChecked() )
    {
	mode = QLCDNumber::BIN;
    }
    
    num->setMode( mode );

    QLCDNumber::SegmentStyle style = QLCDNumber::Outline;
    
    if( isSegmentFilled->isChecked() )
    {
	style = QLCDNumber::Filled;
    }
    else if( isSegmentFlat->isChecked() )
    {
	style = QLCDNumber::Flat;
    }

    num->setSegmentStyle( style );

    QString str = itsNumDigits->text();
    num->setNumDigits( str.toInt() );
    num->setSmallDecimalPoint( isSmallPoint->isChecked() );
}

    
    
