#include <qlistbox.h>

#include "ListBoxPage.h"

#include "widget/DlgWidget.h"

#include "GuiTools.h"

#define Inherited ListBoxPageData

ListBoxPage::ListBoxPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const QListBox* list = (QListBox*)widget->GetWidget();
    
    connect( itsAddButton, SIGNAL(clicked()), SLOT(AddClicked()) );
    connect( itsChangeButton, SIGNAL(clicked()), SLOT(ChangeClicked()) );
    connect( itsDeleteButton, SIGNAL(clicked()), SLOT(DeleteClicked()) );
    connect( itsList, SIGNAL(highlighted(int)), 
	     SLOT(ListSelChanged(int)) );
    connect( itsNewItem, SIGNAL(textChanged(const char*)),
	     SLOT(NewItemChanged(const char*)) );

    GuiTools::TransferListBox( list, itsList );

    isDragSelect->setChecked( list->dragSelect() );
    isAutoScroll->setChecked( list->autoScroll() );
    isScrollbar->setChecked( list->scrollBar() );
    isAutoScrollbar->setChecked( list->autoScrollBar() );
    isBottomScrollbar->setChecked( list->bottomScrollBar() );
    isAutoBottomScrollbar->setChecked( list->autoBottomScrollBar() );
    isSmoothScrolling->setChecked( list->smoothScrolling() );
    isMultiSelection->setChecked( list->isMultiSelection() );
    
    Update();
}


ListBoxPage::~ListBoxPage()
{
}


void ListBoxPage::Apply( DlgWidget*	widget )
{
    QListBox* list = (QListBox*)widget->GetWidget();
    
    GuiTools::TransferListBox( itsList, list );

    list->setDragSelect( isDragSelect->isChecked() );
    list->setAutoScroll( isAutoScroll->isChecked() );
    list->setScrollBar( isScrollbar->isChecked() );
    list->setAutoScrollBar( isAutoScrollbar->isChecked() );
    list->setBottomScrollBar( isBottomScrollbar->isChecked() );
    list->setAutoBottomScrollBar( isAutoBottomScrollbar->isChecked() );
    list->setSmoothScrolling( isSmoothScrolling->isChecked() );
    list->setMultiSelection( isMultiSelection->isChecked() );
}


void ListBoxPage::AddClicked()
{
    const char* text = itsNewItem->text();
    if( text && text[0] )
    {
	itsList->insertItem( text );
    }
}


void ListBoxPage::ChangeClicked()
{
    const char* text = itsNewItem->text();
    if( text && text[0] )
    {
	itsList->changeItem( text, itsList->currentItem() );
    }
}


void ListBoxPage::DeleteClicked()
{
    int item = itsList->currentItem();
    if( item >= 0 )
    {
	itsList->removeItem( item );
	Update();
    }
}


void ListBoxPage::ListSelChanged( int item )
{
    itsNewItem->setText( itsList->text( item ) );
    Update();
}


void ListBoxPage::NewItemChanged( const char* )
{
    Update();
}


void ListBoxPage::Update()
{
    const char* text = itsNewItem->text();
    bool newText = ( text && text[0] );
    bool itemSelected = (itsList->currentItem() != -1);

    itsAddButton->setEnabled( newText );
    itsChangeButton->setEnabled( newText & itemSelected );
    itsDeleteButton->setEnabled( itemSelected );
}


