#include "WidgetCommonPage.h"

#include "widget/DlgWidget.h"

#define Inherited WidgetCommonPageData

WidgetCommonPage::WidgetCommonPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QWidget* wid = widget->GetWidget();
    QString str;
    
    itsName->setText( wid->name() );
    itsCaption->setText( wid->caption() );
    
    str.setNum( wid->x() );
    itsXPos->setText( str );
    str.setNum( wid->y() );
    itsYPos->setText( str );
    str.setNum( wid->width() );
    itsWidth->setText( str );
    str.setNum( wid->height() );
    itsHeight->setText( str );

    QSize size = wid->minimumSize();
    str.setNum( size.width() );
    itsMinWidth->setText( str );
    str.setNum( size.height() );
    itsMinHeight->setText( str );
    
    size = wid->maximumSize();
    str.setNum( size.width() );
    itsMaxWidth->setText( str );
    str.setNum( size.height() );
    itsMaxHeight->setText( str );
}


WidgetCommonPage::~WidgetCommonPage()
{
}


void WidgetCommonPage::Apply( DlgWidget*	widget )
{
    QWidget* wid = widget->GetWidget();
    
    wid->setName( itsName->text() );
    wid->setCaption( itsCaption->text() );
    
    QString str,str1;
    
    str = itsXPos->text();
    str1 = itsYPos->text();
    wid->move( str.toInt(), str1.toInt() );
    
    str = itsWidth->text();
    str1 = itsHeight->text();
    wid->resize( str.toInt(), str1.toInt() );

    str = itsMinWidth->text();
    str1 = itsMinHeight->text();
    wid->setMinimumSize( str.toInt(), str1.toInt() );
    
    str = itsMaxWidth->text();
    str1 = itsMaxHeight->text();
    wid->setMaximumSize( str.toInt(), str1.toInt() );
}


void WidgetCommonPage::SetFixedSize()
{
    itsMinWidth->setText( itsWidth->text() );
    itsMaxWidth->setText( itsWidth->text() );

    itsMinHeight->setText( itsHeight->text() );
    itsMaxHeight->setText( itsHeight->text() );
}
 

void WidgetCommonPage::SetVariableSize()
{
    QString str;

    itsMinWidth->setText( str.setNum( 10 ) );
    itsMinHeight->setText( str );
    
    itsMaxWidth->setText( str.setNum( QCOORD_MAX ) );
    itsMaxHeight->setText( str );
}


