#ifndef DlgComboBox_included
#define DlgComboBox_included

#include <qstring.h>
#include <qstrlist.h>

#include "widget/DlgWidget.h"
#include "widget/ComboBox.h"

class DlgComboBox : public DlgWidget
{

public:

    DlgComboBox
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgComboBox();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgComboBox's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QComboBox *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QComboBox *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source


    virtual void GenerateCtor
    (
        QTextStream&            stream,
        const QString&          varName
    );
    // output a constructor for the widget.  The
    // ctor for leaves the output at the start of the next line
    

    enum ComboType
    {
	CT_ReadOnly,
	CT_ReadWrite,
	CT_Motif1x
    };
    
    ComboType GetComboType( void ) const;
    // return the combo box type for this widget

    void SetComboType( ComboType	type );
    // set the type of the combo box

    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list
    
    static const QStrList& GetSignalList( void );
    // method to return the list of signals

private: // static data

    static QStrList	itsSignals;
    // list of the signals that can be connected to this widget

private:

    ComboBox*	itsWidget;

    ComboType	itsComboType;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgComboBox::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgComboBox::GetHeaderFilename() const
{
    return "<qcombo.h>";
}

inline QString DlgComboBox::GetWidgetClass() const
{
    return "QComboBox";
}

inline void DlgComboBox::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName, 
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}


inline DlgComboBox::ComboType DlgComboBox::GetComboType( void ) const
{
    return itsComboType;
}


inline void DlgComboBox::SetComboType( DlgComboBox::ComboType	type )
{
    itsComboType = type;
}


#endif // DlgComboBox_included
