#include "widget/DlgFrame.h"

#include "prop/FramePage.h"

#define Inherited DlgWidget

int DlgFrame::itsNextWidgetNum = 1;

DlgFrame::DlgFrame
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_Frame, parent )
{
    itsWidget = new Frame( parent, CreateName( "Frame", name, 
					       itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgFrame::~DlgFrame()
{
}


void DlgFrame::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new FramePage( this, parent, "Frame" ) );

    labels.append( "Frame" );
}


void DlgFrame::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nFrame {";
  
    DlgFrame::SaveQt( stream, (const QFrame *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgFrame::SaveQt
(
   QTextStream &stream,
   const QFrame *widget
)
{
  QString aStr;

  if( widget->frameStyle() != QFrame::NoFrame )
  {
  aStr.setNum( widget->frameStyle() );
  stream << "\n\t\tStyle {" << aStr << "}";
  }

  if( widget->lineWidth() != 1 )
  {
  aStr.setNum( widget->lineWidth() );
  stream << "\n\t\tLineWidth {" << aStr << "}";
  }

  if( widget->midLineWidth() )
  {
  aStr.setNum( widget->midLineWidth() );
  stream << "\n\t\tMidLineWidth {" << aStr << "}";
  }
}

bool DlgFrame::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgFrame::RestoreQt( key, value, (QFrame *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgFrame::RestoreQt
(
   const QString &key,
   const QString &value,
   QFrame *widget
)
{
  // Compare to known keys
  if( key == "Style" )
  {
    widget->setFrameStyle( value.toInt() );
  } else if( key == "LineWidth" )
  {
    widget->setLineWidth( value.toInt() );
  } else if( key == "MidLineWidth" )
  {
    widget->setMidLineWidth( value.toInt() );
  } else
  {
    // Key unknown
    return FALSE;
  }
  return TRUE;
}  


void DlgFrame::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );
    
    const QFrame* widget = (const QFrame*)dlgWidget.GetWidget();

    if( widget->frameStyle() != QFrame::NoFrame )
    {
	stream << varName << "setFrameStyle( " << widget->frameStyle() << 
	    " );\n";
    }
    
    if( widget->lineWidth() != 1 )
    {
	stream << varName << "setLineWidth( " << widget->lineWidth() <<
	    " );\n";
    }
    
    if( widget->midLineWidth() )
    {
	stream << varName << "setMidLineWidth( " << widget->midLineWidth() <<
	    " );\n";
    }
}



