#include "widget/DlgSlider.h"
#include "widget/DlgFrame.h"

#include "prop/SliderPage.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgSlider::itsSignals;
int DlgSlider::itsNextWidgetNum = 1;

DlgSlider::DlgSlider
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_Slider, parent )
{
    itsWidget = new Slider( parent, CreateName( "Slider", name, 
						itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgSlider::~DlgSlider()
{
}


void DlgSlider::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new SliderPage( this, parent, "Slider" ) );

    labels.append( "Slider" );
}


void DlgSlider::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nSlider {";
  
    DlgSlider::SaveQt( stream, (const QSlider *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgSlider::SaveQt
(
   QTextStream &stream,
   const QSlider *widget
 )
{
  QString aStr;

  stream << "\n\t\tOrientation {";
  if( widget->orientation() == QSlider::Horizontal )
      stream << "Horizontal";
  else
      stream << "Vertical";
  stream << "}";

  stream << "\n\t\tMinValue {" << aStr.setNum( widget->minValue() ) << "}";
  stream << "\n\t\tMaxValue {" << aStr.setNum( widget->maxValue() ) << "}";
  stream << "\n\t\tInitial {" << aStr.setNum( widget->value() ) << "}";
  stream << "\n\t\tLineStep {" << aStr.setNum( widget->lineStep() ) << "}";
  stream << "\n\t\tPageStep {" << aStr.setNum( widget->pageStep() ) << "}";

  stream << "\n\t\tTracking {";
  SaveBool( stream, widget->tracking() );
  stream << "}";
  
  stream << "\n\t\tTickmarks {" << 
      GuiTools::QSliderTickSettingStr( widget->orientation(), 
				       ((QSlider*)widget)->tickmarks() ) << 
      "}";
  stream << "\n\t\tTickInterval {" << widget->tickInterval() << "}";
}

bool DlgSlider::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgSlider::RestoreQt( key, value, (QSlider *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgSlider::RestoreQt
(
   const QString &key,
   const QString &value,
   QSlider *widget
)
{
    // Compare to known keys
    if( key == "Orientation" )
    {
	if( value == "Horizontal" )
	    widget->setOrientation( QSlider::Horizontal );
	else
	    widget->setOrientation( QSlider::Vertical );
    } 
    else if( key == "MinValue" )
    {
	int max = widget->maxValue();
	widget->setRange( value.toInt(), max );
    }
    else if( key == "MaxValue" )
    {
	int min = widget->minValue();
	widget->setRange( min, value.toInt() );
    }
    else if( key == "Initial" )
    {
	widget->setValue( value.toInt() );
    }
    else if( key == "LineStep" )
    {
	int page = widget->pageStep();
	widget->setSteps( value.toInt(), page );
    }
    else if( key == "PageStep" )
    {
	int line = widget->lineStep();
	widget->setSteps( line, value.toInt() );
    }
    else if( key == "Tracking" )
    {
	widget->setTracking( (value == "TRUE") );
    }
    else if( key == "Tickmarks" )
    {
	widget->setTickmarks( GuiTools::QSliderTickSetting( value ) );
    }
    else if( key == "TickInterval" )
    {
	widget->setTickInterval( value.toInt() );
    }
    else
    {
	// Key unknown
	return FALSE;
    }
    return TRUE;
}  


void DlgSlider::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QSlider* widget = (const QSlider*)dlgWidget.GetWidget();

    if( widget->orientation() == QSlider::Horizontal )
    {
	stream << varName << "setOrientation( QSlider::Horizontal );\n";
    }
    
    stream << varName << "setRange( " << widget->minValue() << ", " <<
	widget->maxValue() << " );\n";

    stream << varName << "setSteps( " << widget->lineStep() << ", " <<
	widget->pageStep() << " );\n";
    
    stream << varName << "setValue( " << widget->value() << " );\n";

    stream << varName << "setTracking( " <<
	(widget->tracking() ? "TRUE" : "FALSE") << " );\n";

    stream << varName << "setTickmarks( QSlider::" <<
	GuiTools::QSliderTickSettingStr( widget->orientation(), 
					 ((QSlider*)widget)->tickmarks() ) << 
	" );\n";

    stream << varName << "setTickInterval( " << widget->tickInterval() <<
	" );\n";
}


void DlgSlider::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgSlider::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "valueChanged(int)" );
	itsSignals.append( "sliderPressed()" );
	itsSignals.append( "sliderMoved(int)" );
	itsSignals.append( "sliderReleased()" );
    }

    return itsSignals;
}

