#ifndef DlgUser_included
#define DlgUser_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/Label.h"

class DlgUser : public DlgWidget
{

public:

    DlgUser
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgUser();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgUser's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QLabel *
    );
    // Used by original Qt subclasses
    // not used by DlgUser

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QLabel *
    );
    // Used by original Qt subclasses
    // not user by DlgUser

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

    void SetUserClassHeader( const QString&	header );
    // set the class header

    QString GetUserClassHeader( void ) const;
    // get the class header

    void SetUserClassName( const QString&	name );
    // set the class name

    // GetWidgetClass will return the user class name

private:

    Label*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

    QString	itsUserClassHeader;
    // filename containing the class declaration for the widget

    QString	itsUserClassName;
    // name of the user class

};


inline QWidget* DlgUser::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgUser::GetWidgetClass() const
{
    return itsUserClassName;
}


inline void DlgUser::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}


inline void DlgUser::SetUserClassHeader( const QString&	header )
{
    itsUserClassHeader = header;
}


inline QString DlgUser::GetUserClassHeader( void ) const
{
    return itsUserClassHeader;
}


inline void DlgUser::SetUserClassName( const QString& 	name )
{
    itsUserClassName = name;
}

#endif // DlgUser_included

