// 2D Gadgeteditor eXperiment

#include <toad/toad.hh>
#include <toad/form.hh>
#include <toad/menubar.hh>
#include <toad/fatradiobutton.hh>
#include <toad/pushbutton.hh>
#include <toad/gadget.hh>
#include <toad/gadget/line.hh>
#include <toad/gadgeteditor.hh>

#include <fstream>

#include "pencil.hh"

class TMainWindow:
	public TForm
{
		typedef TForm super;
	public:
		TMainWindow(TWindow*, const string&);
		
		void menuOpen(TGadgetWindow *gw);
		void menuSave(TGadgetWindow *gw);
};

void TMainWindow::menuOpen(TGadgetWindow *gw)
{
	ifstream in("picture.vec");
	TInObjectStream oin(&in);
	gw->Restore(oin);
}

void TMainWindow::menuSave(TGadgetWindow *gw)
{
	ofstream out("picture.vec");
	TOutObjectStream oout(&out);
	gw->Store(oout);
}

extern void CreateMemoryFiles();

int ToadMain()
{
	CreateMemoryFiles();
	return TMainWindow(NULL, "TOAD 2D Draw eXperiment").Run();
}

#if 0

class TFigure:
	public TGadget
{
	private:
		void paint(TPen&, EPaintType) {}
	public:
		virtual void paint(TPencil&, EPaintType) = 0;
};

class TFRectangle:
	public TFigure
{
	public:
		TFRectangle();
		void paint(TPencil&, EPaintType);
		void getShape(TRectangle&);
		double distance(int x, int y);
		void translate(int x, int y);
		bool getHandle(unsigned n, TPoint &p);
		void translateHandle(unsigned handle, int mx, int my);
		
		unsigned mouseLDown(TGadgetEditor*, int, int, unsigned);
		unsigned mouseMove(TGadgetEditor*, int, int, unsigned);
		unsigned mouseLUp(TGadgetEditor*, int, int, unsigned);
		
		TCloneable* clone() { return new TFRectangle(*this); }
		void store(TOutObjectStream&, ulong);
		void restore(TInObjectStream&, ulong);
		
		TDPoint p1, p2;
};

TFRectangle::TFRectangle()
{
}

void TFRectangle::paint(TPencil&, EPaintType)
{
}

void TFRectangle::getShape(TRectangle&)
{
}

double TFRectangle::distance(int x, int y)
{
}

double TFRectangle::translate(int x, int y)
{
}

void TFRectangle::translateHandle(unsigned handle, int mx, int my)
{
}

unsigned TFRectangle::mouseLDown(TGadgetEditor*, int, int, unsigned)
{
}

unsigned TFRectangle::mouseMove(TGadgetEditor*, int, int, unsigned)
{
}

void TFRectangle::store(TOutObjectStream&, ulong)
{
}


void TFRectangle::restore(TInObjectStream&, ulong)
{
}


TFRectangle::
{
}


TFRectangle::
{
}


TFRectangle::
{
}


TFRectangle::
{
}


TFRectangle::
{
}


TFRectangle::
{
}


TFRectangle::
{
}

#endif

TMainWindow::TMainWindow(TWindow *p, const string &t):
	super(p, t)
{
	TGadgetEditor *me = new TGadgetEditor(this, "gadgeteditor");
	me->SetBackground(255,255,255);

	TMenuBar *mb = new TMenuBar(this, "menubar");
	TMenuItem *mi;
	
	mb->BgnPulldown("File");
	mi = mb->AddItem("New");
	mi = mb->AddItem("Open..");
		CONNECT(mi->sigActivate, this, menuOpen, me);
	mi = mb->AddItem("Save");
		CONNECT(mi->sigActivate, this, menuSave, me);
	mi = mb->AddItem("Save As..");
	mi = mb->AddItem("Close");
	mi = mb->AddItem("Exit");
	mb->EndPulldown();

	
	SetBackground(192,192,192);
	SetSize(640,480);

	static TGRectangle grect;
	static TGCircle gcirc;
	static TGLine gline;
	static TGText gtext;
	
	TRadioState *state = new TRadioState();
	TWindow *prev = mb;
	TWindow *wnd;
	TButtonBase *rb;
	for(unsigned i=0; i<=20; i++) {
		wnd = NULL;
		switch(i) {
			case 0:
				wnd = rb = new TFatRadioButton(this, "select", state, i);
				Distance(rb, 3, TOP);
				rb->LoadBitmap("memory://resource/tool_select.png");
				CONNECT(rb->sigActivate, me, SetOperation, TGadgetEditor::OP_SELECT);
				rb->SetDown();
				break;
			case 1:
				wnd = rb = new TFatRadioButton(this, "rectangle", state, i);
				rb->LoadBitmap("memory://resource/tool_rect.png");
				CONNECT(rb->sigActivate, me, SetCreate, &grect);
				break;
			case 2:
				wnd = rb = new TFatRadioButton(this, "circle", state, i);
				rb->LoadBitmap("memory://resource/tool_circ.png");
				CONNECT(rb->sigActivate, me, SetCreate, &gcirc);
				break;
			case 3:
				wnd = rb = new TFatRadioButton(this, "line", state, i);
				rb->LoadBitmap("memory://resource/tool_line.png");
				CONNECT(rb->sigActivate, me, SetCreate, &gline);
				break;
			case 4:
				wnd = rb = new TFatRadioButton(this, "text", state, i);
				rb->LoadBitmap("memory://resource/tool_text.png");
				CONNECT(rb->sigActivate, me, SetCreate, &gtext);
				break;
				
			case 13:
				wnd = rb = new TPushButton(this, "group", i);
				Distance(rb, 3, TOP);
				rb->LoadBitmap("memory://resource/tool_group.png");
				CONNECT(rb->sigActivate, me, Group);
				break;
			case 14:
				wnd = rb = new TPushButton(this, "ungroup", i);
				rb->LoadBitmap("memory://resource/tool_ungroup.png");
				CONNECT(rb->sigActivate, me, Ungroup);
				break;

			case 15:
				wnd = rb = new TPushButton(this, "top", i);
				Distance(rb, 3, TOP);
				rb->LoadBitmap("memory://resource/tool_top.png");
				CONNECT(rb->sigActivate, me, Selection2Top);
				break;
			case 16:
				wnd = rb = new TPushButton(this, "up", i);
				rb->LoadBitmap("memory://resource/tool_up.png");
				CONNECT(rb->sigActivate, me, SelectionUp);
				break;
			case 17:
				wnd = rb = new TPushButton(this, "down", i);
				rb->LoadBitmap("memory://resource/tool_down.png");
				CONNECT(rb->sigActivate, me, SelectionDown);
				break;
			case 18:
				wnd = rb = new TPushButton(this, "bottom", i);
				rb->LoadBitmap("memory://resource/tool_bottom.png");
				CONNECT(rb->sigActivate, me, Selection2Bottom);
				break;
		}
		if (wnd) {
			wnd->SetSize(34,34);
			Attach(wnd, TOP, prev);
			Attach(wnd, LEFT);
			Distance(wnd, 3, LEFT|RIGHT);
			prev = wnd;
		}
	}

	Attach(mb, TOP|LEFT|RIGHT);
	Attach(me, TOP, mb);
	Attach(me, RIGHT|BOTTOM);
	Attach(me, LEFT, prev);
}
