#include "figure.hh"
#include "pencil.hh"

void TFigure::InitStorage()
{
	serialize.Register(new TFigText(), 			"TOAD:TFigText");
	serialize.Register(new TFigRectangle(),	"TOAD:TFigRectangle");
	serialize.Register(new TFigCircle(),		"TOAD:TFigCircle");
	serialize.Register(new TFigGroup(),			"TOAD:TFigGroup");
}

TSerializeBase TFigure::serialize(2);

TFigure::~TFigure()
{
//	cout << "destroying gadget " << this << endl;
}

double TFigure::Distance2Line(double x, double y, double x1, double y1, double x2, double y2)
{
	double bx = x2 - x1;
	double by = y2 - y1;
	double ax = x-x1;
	double ay = y-y1;
	double lb = bx*bx+by*by;
	double t = (bx * ax + by * ay ) / lb;
	if (t<0.0 || t>1.0)
		return OUT_OF_RANGE;
	return fabs(by * ax - bx * ay) / sqrt(lb);
}

void TFigure::DrawHandle(TPencil& pen, double x, double y)
{
	pen.FillRectangle(x-2,y-2,5.0,5.0);
}

bool TFigure::IsInHandle(double hx, double hy, double x, double y)
{
	cout << "is " << x << "," << y << " near " << hx << "," << hy << endl;
	return (hx-2.0<=x && x<=hx+2.0 && hy-2.0<=y && y<=hy+2.0);
}

void TFigure::store(TOutBinStream &file, ulong version)
{
	if (version>=2) {
		file.WriteByte(line_color.r);
		file.WriteByte(line_color.g);
		file.WriteByte(line_color.b);
		if (filled) {
			file.WriteByte(1);
			file.WriteByte(fill_color.r);
			file.WriteByte(fill_color.g);
			file.WriteByte(fill_color.b);
		} else {
			file.WriteByte(0);
		}
	}
}

void TFigure::restore(TInBinStream &file, ulong version)
{
	if (version>=2) {
		line_color.r = file.ReadByte();
		line_color.g = file.ReadByte();
		line_color.b = file.ReadByte();
		if (file.ReadByte()) {
			filled = true;
			fill_color.r = file.ReadByte();
			fill_color.g = file.ReadByte();
			fill_color.b = file.ReadByte();
		} else {
			filled = false;
		}
	}
}
