#include "figure.hh"
#include "pencil.hh"

void 
TFigRectangle::paint(TPencil &pen,bool)
{
	pen.SetLineColor(line_color);
	if (!filled) {
		pen.DrawRectangle(x,y,w,h);
	} else {
		pen.SetFillColor(fill_color);
		pen.FillRectangle(x,y,w,h);
	}
}

void 
TFigRectangle::paintHandles(TPencil &pen)
{
	DrawHandle(pen, x, y);
	DrawHandle(pen, x+w, y);
	DrawHandle(pen, x+w, y+h);
	DrawHandle(pen, x, y+h);
}

double 
TFigRectangle::distance(double mx, double my)
{
  if (filled && IsInside(mx, my))
		return INSIDE;

	double x1,y1,x2,y2;
	double min = OUT_OF_RANGE, d;
	
	for(int i=0; i<4; i++) {
		switch(i) {
		case 0:
			x1=x; y1=y; x2=x+w; y2=y;
			break;
		case 1:
			x1=x+w; y1=y+h;
			break;
		case 2:
			x2=x; y2=y+h;
			break;
		case 3:
			x1=x; y1=y;
			break;
		}
		d = Distance2Line(mx,my, x1,y1, x2,y2);
		if (d<min)
			min = d;
	}
	return min;
}

void 
TFigRectangle::translate(double dx, double dy)
{
	x+=dx;
	y+=dy;
}

int 
TFigRectangle::getHandle(double mx, double my)
{
	if (IsInHandle(x,  y,   mx,my))
		return 0;
	if (IsInHandle(x+w,y,   mx,my))
		return 1;
	if (IsInHandle(x+w,y+h, mx,my))
		return 2;
	if (IsInHandle(x,  y+h, mx,my))
		return 3;
	return -1;
}

int
TFigRectangle::translateHandle(int handle, double mx, double my)
{
	switch(handle) {
		case 0:
		case 3:
			w-=mx-x;
			x=mx;
			if (w<0) {
				x+=w;
				w=-w;
				handle = handle==0 ? 1 : 2;
			}
			break;
		case 1:
		case 2:
			w=mx-x+1;
			if (w<0) {
				x+=w;
				w=-w;
				handle = handle==1 ? 0 : 3;
			}
			break;
	}
	switch(handle) {
		case 0:
		case 1:
			h-=my-y;
			y=my;
			if (h<0) {
				y+=h;
				h=-h;
				handle ^= 3;
			}
			break;
		case 2:
		case 3:
			h=my-y+1;
			if (h<0) {
				y+=h;
				h=-h;
				handle ^= 3;
			}
			break;
	}
	return handle;
}

static bool just_started;
static double x1, y1;

void
TFigRectangle::startCreate()
{
	just_started = true;
}

unsigned 
TFigRectangle::stop()
{
	return NOTHING;
}

unsigned 
TFigRectangle::mouseLDown(TFigureEditor *editor, double mx, double my, unsigned)
{
	x1 = x = mx;
	y1 = y = my;
	editor->InvalidateFigure(this);
	return CONTINUE;
}

unsigned 
TFigRectangle::mouseMove(TFigureEditor *editor, double mx, double my, unsigned)
{
	just_started = false;
	editor->InvalidateFigure(this);
	x = x1;
	y = y1;
	w = mx-x;
	h = my-y;
	Adjust();
	editor->InvalidateFigure(this);
	return CONTINUE;
}

unsigned 
TFigRectangle::mouseLUp(TFigureEditor *editor, double mx, double my, unsigned)
{
	if (just_started)
		return STOP|DELETE;
	mouseMove(editor,mx,my,0);
	return STOP;
}

void 
TFigRectangle::store(TOutBinStream &file, ulong version)
{
	super::store(file,version);
	file.WriteSWord(x);
	file.WriteSWord(y);
	file.WriteWord(w);
	file.WriteWord(h);
}

void 
TFigRectangle::restore(TInBinStream &file, ulong version)
{
	super::restore(file, version);
	x = file.ReadSWord();
	y = file.ReadSWord();
	w = file.ReadWord();
	h = file.ReadWord();
}
