#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define _TOAD_PRIVATE
#include "pencil.hh"

TPencil::~TPencil()
{
}

TScreenPencil::TScreenPencil(TWindow *wnd):
	pen(wnd)
{
	LoadIdentity();
}

TScreenPencil::TScreenPencil(TBitmap *bmp):
	pen(bmp)
{
	LoadIdentity();
}

void TScreenPencil::LoadIdentity()
{
	m12 = m13 = m21 = m23 = 0.0;
	m11 = m22 = 1.0;
}

void TScreenPencil::Translate(double x, double y)
{
	m13 += x;
	m23 += y;
}

void TScreenPencil::Scale(double x, double y)
{
	m11*=x; m12*=x; m13*=x;
	m21*=y; m22*=y; m23*=y;
}

void TScreenPencil::Rotate(double d)
{
#if 0
	double c = cos(d);
	double s = sin(d);

	double n11 = m11*c + m12*s;
	double n21 = m21*c + m22*s;
	
	s = -s;
	
	m12 = m11*s + m12*c;
	m22 = m21*s + m22*c;
	
	m11 = n11;
	m21 = m21;
#else
	double n11 = m11*cos(d)  + m12*sin(d);
	double n21 = m21*cos(d)  + m22*sin(d);
	double n12 = m11*-sin(d) + m12*cos(d);
	double n22 = m21*-sin(d) + m22*cos(d);
	
	m11=n11;
	m21=n21;
	m12=n12;
	m22=n22;
#endif
}

void TScreenPencil::SetColor(int r, int g, int b)
{
	pen.SetColor(r,g,b);
}

void TScreenPencil::SetLineColor(TRGB &rgb)
{
	pen.SetLineColor(rgb);
}

void TScreenPencil::SetFillColor(TRGB &rgb)
{
	pen.SetFillColor(rgb);
}

inline void map(TScreenPencil *sp, double x, double y, XPoint *pt)
{
	pt->x = (sp->m11*x + sp->m12*y + sp->m13) + 0.5;
	pt->y = (sp->m21*x + sp->m22*y + sp->m23) + 0.5;
}

void TScreenPencil::DrawLine(double x1, double y1, double x2, double y2)
{
	XPoint p1;
	XPoint p2;
	map(this, x1,y1, &p1);
	map(this, x2,y2, &p2);
	XDrawLine(pen.x11display, pen.x11drawable, pen.o_gc, 
		p1.x,p1.y,
		p2.x,p2.y);
}


void TScreenPencil::DrawRectangle(double x, double y, double w, double h)
{
	XPoint pnt[5];
	XPoint *pt = pnt;
	map(this, x  ,y  , pt); pt++;
	map(this, x+w,y  , pt); pt++;
	map(this, x+w,y+h, pt); pt++;
	map(this, x  ,y+h, pt); pt++;
	pt->x = pnt->x;
	pt->y = pnt->y;
	XDrawLines(pen.x11display, pen.x11drawable, pen.o_gc, pnt, 5, CoordModeOrigin);
}

void TScreenPencil::FillRectangle(double x, double y, double w, double h)
{
	XPoint pnt[5];
	XPoint *pt = pnt;
	map(this, x  ,y  , pt); pt++;
	map(this, x+w,y  , pt); pt++;
	map(this, x+w,y+h, pt); pt++;
	map(this, x  ,y+h, pt); pt++;
	pt->x = pnt->x;
	pt->y = pnt->y;

	XFillPolygon(pen.x11display, 
							 pen.x11drawable,
							 pen.two_colors ? pen.f_gc : pen.o_gc,
							 pnt, 4, Nonconvex, CoordModeOrigin);
	XDrawLines(pen.x11display, pen.x11drawable, pen.o_gc, pnt, 5, CoordModeOrigin);
}

void TScreenPencil::DrawCircle(double x, double y, double w, double h)
{
	XDrawArc(pen.x11display, 
					 pen.x11drawable, 
					 pen.o_gc, 
					 x, y,w,h,
					 0, 360*64 );
}

void TScreenPencil::FillCircle(double x, double y, double w, double h)
{
	XFillArc(pen.x11display, 
					 pen.x11drawable, 
					 pen.two_colors ? pen.f_gc : pen.o_gc,
					 x, y,w,h,
					 0, 360*64 );
	XDrawArc(pen.x11display, 
					 pen.x11drawable, 
					 pen.o_gc, 
					 x, y,w,h,
					 0, 360*64 );
}

double TScreenPencil::Height()
{
	return pen.Height();
}

double TScreenPencil::TextWidth(const string &text)
{
	return pen.TextWidth(text);
}

void TScreenPencil::DrawString(double x, double y, const string &text)
{
	XPoint p1;
	map(this, x,y, &p1);
	pen.DrawString(p1.x, p1.y, text);
}
