/*
 *
 * A Very Simple Yamaha DX7 Synthesizer Sound Editor Example (VSYDX7SSEE)
 * Written 1999 by Mark-Andr Hopf
 *
 * This is an experiment to see how the current data manipulation classes
 * could be improved.
 *
 */

#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/time.h>

#include <toad/toad.hh>
#include <toad/ioobserver.hh>
#include <toad/dialog.hh>
#include <toad/io/resourcefile.hh>
#include <toad/scrollbar.hh>
#include <toad/pushbutton.hh>

class TMainWindow:
	public TDialog
{
		typedef TDialog super;
	public:
		TMainWindow(TWindow* p, const string& t);
};

class TMIDI:
	public TIOObserver
{
	public:
		TMIDI(const string &devname);
		~TMIDI();
		void Write(byte *buf, int size);
};

TMIDI::TMIDI(const string &devname):
	TIOObserver(open(devname.c_str(), O_RDWR))
{
	termios t;
	tcgetattr(fd(), &t);
	t.c_iflag = 0;
	t.c_oflag = 0;
	t.c_lflag = 0;
	t.c_cc[VMIN] = 0;
	t.c_cc[VTIME]= 0;
	t.c_cflag = CREAD | CLOCAL | CS8 | B38400 | HUPCL;
	tcsetattr(fd(), TCSANOW, &t);
};

TMIDI::~TMIDI()
{
	if (fd())
		close(fd());
}

void TMIDI::Write(byte *buf, int size)
{
	write(fd(), buf, size);
}

TMIDI *midi;

class TMidiConnect:
	public TIntInterface
{
		static int counter;
		int no;
		
	public:
		TMidiConnect(byte g, byte h, byte pos) {
			pos1 = (g<<2)+h;
			pos2 = pos;
			value= 99;
			
			counter++;
			no = counter;
		}
		
		byte pos1, pos2;
		byte value;

	protected:
		void Write(const int &data, void *ptr) {
			if (ptr!=NULL) {
				value = data;
				byte buffer[7] = {0xF0, 0x43, 0x1F, 0,0,0, 0xF7};
				buffer[3] = pos1;
				buffer[4] = pos2;
				buffer[5] = 99-data;
				midi->Write(buffer, 7);
			}
		}

		int Read(const void *ptr) const {
			return value;
		}
		
		void* Allocate() {return NULL;}
		void* Pointer() const {return (void*)no;}	// block assimilate with different no
};

int TMidiConnect::counter = 0;

int ToadMain()
{
	midi = new TMIDI("/dev/ttyS0");
	new TResourceFile("layout.res");
	return TMainWindow(NULL, "DX7 Sound Editor").Run();
}

TMainWindow::TMainWindow(TWindow *p, const string &t):
	super(p, t)
{
	TScrollBar *sb;

	char buffer[255];

	for(int op=0; op<6; op++) {
		for(int lvl=0; lvl<4; lvl++) {
			sprintf(buffer, "op%dlvl%d", op, lvl);
			sb = new TVScrollBar(this, buffer);
				sb->SetDirect(true);
				sb->SetInterface(new TMidiConnect(0,0, (5-op) * 21 + 4 + lvl));
				sb->SetRange(0,99);
		}
	}

	DoLayout("Editor");
}
