/*
	Was alles beachtet werden mu um TOAD Thread sicher zu machen:
	- TPen
	- TSignal
*/

#define usleep(A) usleep(50)

#include <toad/toad.hh>
#include <toad/thread.hh>
#include <iostream.h>
#include <unistd.h>

class TMyWindow: 
	public TWindow
{
	public:
		TMyWindow(TWindow* p, const string& t);
		void created();
		void paint();
};

class TPainter:
	public TThread
{
		TWindow *_wnd;
		int _how;
	public:
		TPainter(TWindow *w, int h) { _wnd = w; _how = h;}
	protected:
		void main();
};

int ToadMain()
{
	return TMyWindow(NULL, "thread").Run();
}

TMyWindow::TMyWindow(TWindow* p, const string& t):
	TWindow(p,t)
{
}

void TMyWindow::created()
{
	TPainter *p;
#if 1
	p = new TPainter(this, 1);
	p->Start();
	p = new TPainter(this, 2);
	p->Start();
#endif
	p = new TPainter(this, 3);
	p->Start();
}

void TMyWindow::paint()
{
	TPen pen(this);
	pen.SetColor(TColor::RED);
	pen.FillRectangle(50,50,50,50);
}

void TPainter::main()
{
	printf("thread %d started\n", _how);
	TPen pen(_wnd);
	while(true) {
		switch(_how) {
			case 1:	
				for(int i=0; i<320; i+=2) {
					pen.DrawLine(i,0,i,200);
					TOADBase::Flush();
					usleep(1000000/12);
				}
				break;
			case 2:	
				for(int i=319; i>0; i-=2) {
					pen.DrawLine(i,0,i,200);
					TOADBase::Flush();
					usleep(1000000/12);
				}
				break;
			case 3:
				_wnd->Invalidate();
				_wnd->PaintNow();
				usleep(1000000/6);
				break;
		}
	}
}
