/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
	Example for TOAD first data interface implementation:
*/

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/textfield.hh>
#include <toad/textarea.hh>
#include <toad/checkbox.hh>
#include <toad/pushbutton.hh>
#include <toad/radiobutton.hh>
#include <toad/scrollbar.hh>

class TMainWindow: public TDialog
{
	public:
		TMainWindow(TWindow *, const string &);
		TTextField *tf1;
		TRadioButton *rb1,*rb2,*rb3;

		// these are the attributes the dialog is going to edit:
		//------------------------------------------------------
		string	data1a, data1b;
		int			data2;
		double	data3;
		bool		data4;
		string	data5;
		string  data6a, data6b;
		int     data7a, data7b;

		bool flag;		
		void print();
		void interface();
		
		void printInt(TIntManipulator*);
};

void TMainWindow::printInt(TIntManipulator *sb)
{
	cout << sb->Value() << endl;
}

int ToadMain()
{
	// open the resource file with the dialogs layout information
	//-----------------------------------------------------------
	TOADBase::SetResourcePrefix("file://resource/");
  return TMainWindow(NULL, "data manipulation test").Run();
}

TMainWindow::TMainWindow(TWindow *p, const string &t)
	:TDialog(p,t)
{
	TTextField *tf;
	TPushButton *btn;
	TScrollBar *sb;

  // init the attributes with predefined values
  //-------------------------------------------
	data1a = "Hello";
	data1b = "You";
	data2 = 4711;
	data3 = 3.1415;
	data4 = true;
	data5 = "Battle Angle Alita";
	data7a = data7b = 1;

	flag = false;

	// create a text field control
	// this   : the controls parent window
	// "data1": the controls identification name in the resource file
	// &data1 : a pointer to the attribute the control will modify
	//---------------------------------------------------------------
	tf1 = new TTextField(this, "data1", &data1a);
	
	// create a push button and let the button call `this->interface()'
	// when pushed
	//-----------------------------------------------------------------
	btn = new TPushButton(this, "Interface");
		CONNECT(btn->sigActivate, this,interface);

  // more controls (see above for an explanation of the parameters)
  //---------------------------------------------------------------
	new TTextField(this, "data2", &data2);
	new TTextField(this, "data3", &data3);
	new TCheckBox(this,  "data4", &data4);
	
	// another text field but this one will modify the attribute at
	// `&data5' at once (you have to call `Apply()' before the other
	// controls copy their value to the attribute)
	//--------------------------------------------------------------
	tf = new TTextField(this, "data5", &data5);
		tf->SetDirect(true);

  // radio buttons (old style)
  //---------------------------
  TRadioState* rstate = new TRadioState();
//int rstate=100;
	rb1 = new TRadioButton(this, "option1", rstate, 1);
	rb2 = new TRadioButton(this, "option2", rstate, 2);
	rb3 = new TRadioButton(this, "option3", rstate, 3);
	
	new TTextArea(this, "data6", &data6a);
	
	sb = new THScrollBar(this, "data7a", 		&data7a);
	tf = new TTextField (this, "tf.data7a", &data7a);
	sb = new THScrollBar(this, "data7b", 		&data7b);
	tf = new TTextField (this, "tf.data7b", &data7b);
		sb->SetDirect(true);
		tf->SetDirect(true);
	sb = new TVScrollBar(this, "sb2.data7b", &data7b);
		sb->SetDirect(true);
		CONNECT(sb->sigValueChanged, this, printInt, sb);

	btn = new TPushButton(this, "Apply");
		CONNECT(btn->sigActivate, this, Apply);

	btn = new TPushButton(this, "Reset");
		CONNECT(btn->sigActivate, this, Reset);

	btn = new TPushButton(this, "Print");
		CONNECT(btn->sigActivate, this, print);
		
  // do the layout for all child windows created above; and use
  // the string "TMainWindow" to identify resource in the resource
  // file
  //--------------------------------------------------------------
	DoLayout("TMainWindow");
}

void TMainWindow::print()
{
	cout<< "data1a: " << data1a << endl
			<< "data1b: " << data1b << endl
			<< "data2 : " << data2  << endl
			<< "data3 : " << data3  << endl
			<< "data4 : " << data4  << endl
			<< "data5 : " << data5	<< endl
			<< "data6a: " << data6a << endl
			<< "data7a: " << data7a << endl
			<< "data7b: " << data7b << endl
			<< "rb1   : " << rb1->Value() << endl
			<< "rb2   : " << rb2->Value() << endl
			<< "rb3   : " << rb3->Value() << endl;
}

void TMainWindow::interface()
{
	// change the pointer in the interface of the text field
	//------------------------------------------------------
	if (flag)
		tf1->SetData(&data1a);
	else
		tf1->SetData(&data1b);
	flag=!flag;
}
