/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TColor
#define TColor TColor

#include <toad/pointer.hh>

#define RGB_PALETTE_MAX 126

struct TRGB
{
		byte r,g,b;

		friend bool operator ==(class TRGB, class TRGB);

		bool operator !=(const TRGB &c) {
			return (r==c.r && g==c.g && b==c.b)?false:true;
		}
		void operator() (byte rn,byte gn,byte bn) {
			r=rn;g=gn;b=bn;
		}
		void Set(byte rn,byte gn,byte bn) {
			r=rn;g=gn;b=bn;
		}
};

inline bool operator ==(class TRGB u,class TRGB v) {
	return (u.r==v.r && u.g==v.g && u.b==v.b)?true:false;
}

class TColor
	:public TRGB
{
		friend TPen;
		friend TWindow;
		friend TBitmap;

		class TData:
			public TSmartObject
		{
			public:
				TData();
				~TData();
				bool pixel_is_valid;
				ulong xpixel;
				ulong /* Pixmap */ pm;
		};

	public:
		enum EColor16 {
			BLACK=0,
			RED=1,
			GREEN=2,
			YELLOW=3,
			BLUE=4,
			MAGENTA=5,
			CYAN=6,
			GREY=7, GRAY=7,
			LIGHTGREY=8, LIGHTGRAY=8,
			LIGHTRED,
			LIGHTGREEN,
			LIGHTYELLOW,
			LIGHTBLUE,
			LIGHTMAGENTA,
			LIGHTCYAN,
			WHITE,
			COLOR16_MAX
		};

		enum ESystemColor	{
		  BTNTEXT=0,						// buttonbase
		  BTNSHADOW,
		  BTNFACE,
		  BTNLIGHT,
		  MENU,									// menubar
		  MENUTEXT,
		  TEXTEDIT,
		  MDIAREA,							// mdi stuff
		  CAPTION,
		  CAPTIONTEXT,
		  INACTIVECAPTION,
		  INACTIVECAPTIONTEXT,
		  DIALOG,								// dialog
		  DIALOGTEXT,
		  SLIDER_FACE,					// scrollbar slider
		  SLIDER_SHADOW,
		  SLIDER_LIGHT,
		  SELECTED,
		  SELECTED_TEXT,
		  MAX
		};

		enum EDitherMode {
			NEAREST = 0,
			DITHER16 = 1,
			DITHER27 = 2,
			DITHER125 = 3,
			DITHER = 3
		};


		TColor();
		TColor(byte r, byte g, byte b);
		TColor(EColor16);
		TColor(ESystemColor);
		~TColor();

		void Set(const TRGB &c) {
			r = c.r;
			g = c.g;
			b = c.b;
			_data = NULL;
		}
		void Set(byte cr, byte cg, byte cb) {
			r = cr; g = cg; b = cb;
			_data = NULL;
		}
		void Set(EColor16);
		void Set(ESystemColor);

		TColor& operator =(const TColor &c) {
			r = c.r;
			g = c.g;
			b = c.b;
			_data = c._data;
			return *this;
		}

		TColor& operator =(const TRGB &c) {
			r = c.r;
			g = c.g;
			b = c.b;
			_data = NULL;
			return *this;
		}

#ifndef _TOAD_PRIVATE
	private:
#endif
		void _Init();

		// for pen, window and bitmaps
		//-----------------------------
		void _SetPen(TPen*, _TOAD_GC &gc);
		static ulong _GetPixel(const TRGB&);
		ulong _GetPixel() { return _GetPixel(*this); }
		static ulong _GetPixelAt(const TRGB&, int x,int y);
		ulong _GetPixelAt(int x, int y) { return _GetPixelAt(*this,x,y); }
		static const TColor& _Palette(int i);
		
		static bool _ShouldNotDither();

		typedef GSmartPointer<TData> PData;
		PData _data;
};

#endif
