/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/connect.hh>
#include <iostream>

//! TAction
//. For user defined messages in TOADs' internal message queue.

TAction::TAction()
{
}

TAction::~TAction()
{
}

TSignalBase::TSignalNode::~TSignalNode()
{
}

//! TSignal
//. TSignal is the core of TOADs' callback implementation and calls the
//. methods in the added object:method pairs when triggered.
//. <P>
//. object:method pairs can be added with <CODE>Add</CODE>, which is a
//. <B>100% type safe</B> operation and 
//. <B>all errors will detected during compilation</B>.
//. <P>
//. Another feature is that you may add a parameter with <CODE>Add</CODE>
//. for the method to be called.

TSignal::TSignal()
{
}

void TSignalBase::TSignalNodeCheck::check(void*)
{
}

TSignalBase::TSignalBase()
{
	_list = NULL;
}

TSignalBase::~TSignalBase()
{
	ClearAll();
}

void TSignalBase::Add(TSignalNode *node)
{
	node->_next = NULL;
	if (_list==NULL) {
		_list = node;
	} else {
		TSignalNode *p = _list;
		while(p->_next)
			p=p->_next;
		p->_next = node;
	}
}

//. Remove all assigned object:method pairs.
void TSignalBase::ClearAll()
{
#if 0
	TSignalNode *p;
	while(_list) {
		p = _list;
		_list = _list->_next;
		delete p;
	}
#else
	_list = NULL;
#endif
}

//. Perform all calls to the assigned object:method pairs.
bool TSignalBase::Trigger()
{
	if (_list==NULL)
		return false;
	TSignalNode *p = _list;
	while(p) {
		p->execute();
		p = p->_next;
	}
	return true;
}

// `void TSignalBase::Trigger()' is in `toadbase.cc'
