/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>

// avoid problems on AIX, IRIX, ...
#define exception c_exception
#include <cmath>
#undef exception

void 
TGCircle::paint(TPen &pen, EPaintType)
{
	pen.SetLineColor(line_color);
	if (!filled) {
		pen.DrawCircle(p1,p2);
	} else {
		pen.SetFillColor(fill_color);
		pen.DrawCircle(p1,p2);
	}
}

double 
TGCircle::distance(int mx, int my)
{
	TRectangle r;
	getShape(r);
	double rx = 0.5*(r.w);
	double ry = 0.5*(r.h);
	double cx = (double)r.x+rx;
	double cy = (double)r.y+ry;
	double dx = (double)mx - cx;
	double dy = (double)my - cy;
	
	double phi = atan( (dy*rx) / (dx*ry) );
	if (dx<0.0)
		phi=phi+M_PI;
	double ex = rx*cos(phi);
	double ey = ry*sin(phi);
	if (filled) {
		double d = sqrt(dx*dx+dy*dy)-sqrt(ex*ex+ey*ey);
		if (d<0.0)
			return INSIDE;
		return d;
	}
	dx -= ex;
	dy -= ey;
	return sqrt(dx*dx+dy*dy);
}
