/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadgetwindow.hh>
#include <toad/gadget.hh>
#include <toad/io/binstream.hh>

//! TGadgetWindow
//. <I><A HREF="TGadget.html">Gadgets</A></I> are 2dimensional graphical 
//. objects in TOAD and <I>TGadgetWindow</I> stores and paints them.

void TGadgetWindow::paint()
{
	TPen pen(this);
	TGadgetStorage::iterator p = gadgets.begin();
	while(p!=gadgets.end()) {
		(*p)->paint(pen, TGadget::NORMAL);
		p++;
	}
}

void TGadgetWindow::Store(TOutObjectStream &out)
{
	out.WriteDWord(gadgets.size());
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	while(p!=e) {
		TGadget::Store(out, *p);
		p++;
	}
}

void TGadgetWindow::Restore(TInObjectStream &in)
{
	gadgets.erase(gadgets.begin(), gadgets.end());
	unsigned count = in.ReadDWord();
	for(unsigned i=0; i<count; i++) {
		TGadget *g = TGadget::Restore(in);
		if (dynamic_cast<TGWindow*>(g))
			g->removeable = false;
		else
			g->removeable = true;
		gadgets.push_back(g);
	}
	Invalidate();
}
