/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/io/serializable.hh>
#include <vector>
#include <strstream>
#include <typeinfo>
#include <stdexcept>
#include <cstdio>

#define DBM(CMD)

//!TCloneable
//. <H3>Experimental code</H3>
//. Super class for cloneable classes.

//!TSerializable
//. <H3>Experimental code</H3>

//!TSerializeBase
//. <H3>Experimental code</H3>
//.  Manages 

TSerializeBase::TSerializeBase()
{
}

TSerializeBase::~TSerializeBase()
{
	TSerializableBuffer::iterator p=_buffer.begin(), e=_buffer.end();
	while(p!=e) {
//		cout << "delete gadget " << (*p) << endl;
		delete (*p).obj;
		p++;
	}
}

//. Register a new object for serialization.
//. <P>
//. <I>obj</I> is an example of the class used for object identification and
//. recreation, <I>name</I> is used to identify the object in the serialized
//. data stream.
//. <P>
//. <I>TSerializeBase</I> will delete <I>obj</I> in its destructor.
void TSerializeBase::Register(TSerializable *obj, const string &name)
{
	// should produce warning when name appears more than once
	_buffer.push_back(TNode(obj, name));
}

//. Remove all registered objects.
void TSerializeBase::UnregisterAll()
{
	TSerializableBuffer::iterator p, e;
	p = _buffer.begin();
	e = _buffer.end();
	while(p!=e) {
		delete (*p).obj;
		p++;
	}
	_buffer.clear();
}

void TSerializeBase::Store(TOutObjectStream &file, TSerializable *obj)
{
	if (file.used_by==NULL)
		file.used_by = this;
	else if (file.used_by!=this)
		cerr << "warning: TOutObjectStream is used by different TSerializeBases" << endl;

	if (!file.wrote_header) {
		file.WriteDWord(4);					// header size
		file.WriteDWord(version);		// 4 bytes
		file.wrote_header = true;
	}

	TSerializableBuffer::iterator p=_buffer.begin(), e=_buffer.end();
	unsigned long id=0;
	const type_info &ot = typeid(*obj);
	while(p!=e) {
		if ( typeid(*(*p).obj) == ot ) {
			// write type
			//------------
			// lookup `(*p).name' in `file'
DBM(cout << "storing object with name " << (*p).name << endl;)
			TOutObjectStream::TTable::iterator pm = file.table.find((*p).name);
			if (pm!=file.table.end()) {
DBM(cout << "  stored before, using number " << (*pm).second << endl;)
				// found -> write number
				file.WriteDWord((*pm).second);
			} else {
DBM(cout << "  type is stored the first time, new number " << file.table.size()+1 << endl;)
				// not found -> write 0 & name
				file.WriteDWord(0);
				file.WriteWord((*p).name.size());
				file.WriteString((*p).name.c_str(), (*p).name.size());
				file.table[(*p).name] = file.table.size();	// first no. is `1'
			}
			obj->store(file, version);
			return;
		}
		id++;
		p++;
	}
	cerr << "warning: tried to store an unregistered object, ignored" << endl;
}

TSerializable* TSerializeBase::Restore(TInObjectStream &file)
{
	if (file.used_by==NULL)
		file.used_by = this;
	else if (file.used_by!=this)
		cerr << "warning: TInObjectStream is used by different TSerializeBases" << endl;

	if (!file.read_header) {
		ulong header_size  = file.ReadDWord();
		ulong header_start = file.TellRead();
		file.version = file.ReadDWord();
		file.SeekRead(header_start + header_size);
		file.read_header = true;
	}

	// restore objects
	//------------------------------
	unsigned long id = file.ReadDWord();
DBM(cout << "type id " << id << endl;)
	if (id==0) {
		// if `id' == 0, read name, locate object for name, add object pointer to table
		string name;
		unsigned len = file.ReadWord();
		name = file.ReadString(len);
DBM(cout << "found type name " << name << endl;)
		TSerializableBuffer::iterator p=_buffer.begin(), e=_buffer.end();
		while(p!=e) {
			if ( (*p).name == name )
				break;
			p++;
		}
		if (p==e) {
			char buffer[4096];
			sprintf(buffer, "TSerializeBase::Restore: unknown type `%s'", name.c_str());
			throw runtime_error(buffer);
		}
		file.table.push_back( (*p).obj );
		id = file.table.size();
DBM(cout << "  assigned id " << id << endl;)
	}
	id--;

	if (id>=_buffer.size()) {
		ostrstream out;
		out << "TSerializeBase:Restore: object id out of bounds at position " <<
			file.TellRead() << ".\0";
		throw runtime_error(out.str());
	}

	TSerializable *obj = static_cast<TSerializable*>(file.table[id]->clone());
	obj->restore(file, file.version);
	return obj;
}
