/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/font.hh>
#include <toad/pushbutton.hh>
#include <toad/messagebox.hh>

//! TMessageBox
//. For the MessageBox function in <A HREF="TOADBase.html">TOADBase</A>.

TMessageBox::TMessageBox(TWindow* p, 
												 const string &t1, 
												 const string &t2,
												 ulong t,
												 TBitmap *bitmap,
												 EWindowPlacement placement)
	:TWindow(p,t1)
{
	SetBackground(TColor::DIALOG);
	bShell = bStaticFrame = true;
	bFocusManager = true;
	_placement = placement;

	text=t2;
	type=t;
	result=0;
	this->bitmap = bitmap;

	#define VSPACE 16

 	// icon dimensions
	int icon_width, icon_height;
	if (bitmap) {
    icon_width = bitmap->width;
    icon_height = bitmap->height;
  } else {
    icon_width = 32;
    icon_height = 32;
  }

 	// button dimensions
	const unsigned btn_width  = 100;		// width for all buttons
	const unsigned btn_height = DefaultFont().Height() + 8;
	const unsigned btn_hspace = 8;			// space between buttons
	const unsigned vspace = VSPACE;			// space between buttons and window bottom

	unsigned y;

	int msg_height;
	int msg_width=380-32 + icon_width;		// width of the messagebox

	// space for icon & position for text;
	if (type & 0xF000 || bitmap)
		tx=icon_width+32;					// text x position
	else
		tx=8;

 	// text size
	int txt_width = msg_width - tx - 8;
	int txt_height = DefaultFont().GetHeightOfTextFromWidth(text, txt_width)
		- DefaultFont().Height();
	tw = txt_width;	// store value for 'paint()' method

	if (txt_height<icon_height)	{
		ty = vspace+icon_height/2-txt_height/2;
		iy = vspace;
		txt_height=icon_height;
	}	else {
		ty = vspace;
		iy = vspace+txt_height/2-icon_height/2;
	}

	y = (vspace<<1) + txt_height;
	
	msg_height = vspace + txt_height + (vspace<<1) + btn_height;
	
	SetSize(msg_width,msg_height);

 	// create buttons
  //----------------
    	
	// count buttons
	unsigned btn = type & 0xFF;
	unsigned n = 0;
	for(int i=0; i<8; i++) {
		if(btn&1)
			n++;
		btn>>=1;
	}
	if (n==0)	{
		type|=MB_OK;
		n++;
	}
	
  // create buttons
	unsigned w = n * btn_width + (n-1) * btn_hspace;
	unsigned x = (_w - w)>>1;
	static const char* label[8] =
	{
		"Accept","Abort","Ok","Retry","Yes","No","Cancel","Ignore"
	};
	btn = type & 0xFF;
	unsigned count = 0;
	for(unsigned i=0; i<8; i++)	{
		if (btn&1) {
			// create button
			TPushButton *pb = new TPushButton(this, label[i], 1<<i);
				OLD_CONNECT(this,button, pb,pb->sigActivate);
				pb->SetShape(x,y,btn_width,btn_height);
			x=x+btn_width+btn_hspace;
			// MB_DEFBUTTON?
			count+=0x0100;
			if (count == (type & 0x0F00) && LastChild())
				LastChild()->SetFocus();
		}
		btn>>=1;
	}
}

unsigned TMessageBox::GetResult()
{
	return result;
}

void TMessageBox::button(TPushButton* pb)
{
	result = pb->ID();
	EndDialog(this);
}

void TMessageBox::adjust()
{
	TOADBase::PlaceWindow(this, _placement, Parent());
}

void TMessageBox::paint()
{
	TPen pen(this);
	pen.DrawTextWidth(tx,ty,text,tw);

	int x=16;
	int y=iy;

	if (bitmap)	{
		pen.DrawBitmap(x,y,bitmap);
		return;
	}

	// draw icon	
	switch(type & 0xF000)
	{
		case MB_ICONINFORMATION: {
			pen.SetColor(0,0,128);
			pen.FillCircle(x,y,32,32);
			pen.SetColor(0,0,0);
			pen.DrawCircle(x,y,32,32);
			
			pen.SetColor(255,255,255);
			#define TPOINT(a,b,c) p[a].x=b+x;p[a].y=c+y;
			TPoint p[10];
			TPOINT(0,11,11);
			TPOINT(1,19,11);
			TPOINT(2,19,25);
			TPOINT(3,22,25);
			TPOINT(4,22,27);
			TPOINT(5,11,27);
			TPOINT(6,11,25);
			TPOINT(7,14,25);
			TPOINT(8,14,12);
			TPOINT(9,11,12);
			#undef TPOINT
			pen.FillPolygon(p,10);
			pen.FillRectangle(x+14,y+2,4,7);
			pen.FillRectangle(x+13,y+3,6,5);
			pen.FillRectangle(x+12,y+4,8,3);
			} break;

		case MB_ICONEXCLAMATION:
			pen.SetColor(255,255,0);
			pen.FillCircle(x,y,32,32);
			pen.SetColor(0,0,0);
			pen.DrawCircle(x,y,32,32);
			pen.FillRectangle(x+12,y+3,8,18);
			pen.FillRectangle(x+15,y+22,2,8);
			pen.FillRectangle(x+13,y+23,6,6);
			pen.FillRectangle(x+12,y+25,8,2);
			break;

		case MB_ICONSTOP:
			pen.SetColor(255,0,0);
			pen.FillCircle(x,y,32,32);
			pen.SetColor(0,0,0);
			pen.DrawCircle(x,y,32,32);
			pen.SetColor(255,255,255);
			pen.FillRectangle(x+3,y+13,26,6);
			break;

		case MB_ICONQUESTION:
			pen.SetColor(0,128,0);
			pen.FillCircle(x,y,32,32);
			pen.SetColor(0,0,0);
			pen.DrawCircle(x,y,32,32);
			pen.SetColor(255,255,255);
			static struct {int x,y,w,h;} r[17]={
			{7,7,6,5},
			{19,7,6,6},
			{13,2,6,6},
			{11,3,10,5},
			{18,4,5,5},
			{9,4,5,5},
			{8,5,16,2},
			{12,19,8,3},
			{13,17,7,2},
			{14,16,7,2},
			{15,15,7,1},
			{16,14,7,1},
			{17,13,7,1},
			{18,12,2,2},
			{12,25,8,3},
			{13,24,6,5},
			{14,23,4,7}};
			for(int i=0; i<17; i++)
				pen.FillRectangle(r[i].x+x,r[i].y+y,r[i].w,r[i].h);
			break;
	}
}
