/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TTextArea
#define TTextArea TTextArea

#include <toad/scrolledarea.hh>
#include <toad/macros.hh>

class TTextArea
	:public TScrolledArea, public TStringManipulator
{
		typedef TScrolledArea super;
		class TBlink;
		friend TBlink;
		
	public:
		TTextArea(TWindow*,const string&);
		~TTextArea();

		bool _enabled;
		void SetEnabled(bool);

		template <class T>
		TTextArea(TWindow* p, const string &t, T *d):
			super(p, t)
		{
			_Init();
			SetInterface(NewStringInterface(d));
		}

		void putData(const string &data);
		const string& getData();

		unsigned CursorX() { return (_cx==npos ? _sx : _line2x(_cx, _line))+1; }
		unsigned CursorY() { return _cy+1; }
		unsigned Lines()   { return _th-1; }
		unsigned GotoLine(unsigned);
		void Find(const string&);
		
		bool Modified() { return _line_modified || _modified; }
		void SetModified(bool b) {
			if (_modified!=b) {
				_modified = b;
				sigStatus();
			}
		}

		TSignal sigTextChanged;
		TSignal sigStatus;
		
		struct TConfiguration {
			unsigned tabwidth;
		};
		
		void GetConfiguration(TConfiguration *c) {
			
		}
		void SetConfiguration(TConfiguration *c) {
			_tabwidth = c->tabwidth;
		}
	protected:
		void keyDown(TKey,char*,unsigned);
		void mouseLDown(int,int,unsigned);
		void mouseLUp(int,int,unsigned);
		void mouseMove(int,int,unsigned);
		void mouseMDown(int,int,unsigned);
		void paint();
		void focus();
		
		virtual unsigned char filter(unsigned char);
		TFont *font;
		
		
	private:
		void _Init();
		void _Reset();
		unsigned _tabwidth;			// tab width
		unsigned _leftborder;
		unsigned _rightborder;
		bool _autoident:1;
		bool _overtype:1;
		bool _word_wrap:1;
		
		bool _line_modified:1;	// `true' when line was modified
		bool _modified:1;				// `true' when the whole text was modified

		bool _selection_visible:1;
		unsigned _selection_left, _selection_right;

		static const unsigned npos = (unsigned)-1;
		unsigned _cx, _cy;			// cursor position in text
		unsigned _sx;						// screen position of cursor when _cx==npos
		unsigned _tw, _th;			// text height & width
		string _line;						// line buffer
		unsigned _bline;				// start of line buffer in _data
		
		bool _wordstar_control;	// CTRL+K was pressed (some kind of a hack)
		
		// line editing methods
		void _insert(unsigned char);
		void _insert(const string&);
		void _return();
		void _delete();
		void _backspace();
		void _cursor_right();
		void _cursor_left();
		void _cursor_up();
		void _cursor_down();
		void _cursor_home();
		void _cursor_end();
		void _page_down();
		void _page_up();
		
		void _delete_line();

		void _store_line();					// copy line buffer into _data
		void _fetch_line();					// copy line from _data to line buffer
		
		void _selection_copy();			// copy selection to cursor
		void _selection_erase();		// erase selected text
		void _selection_move();			// move selected text to cursor

		unsigned _y2buffer(unsigned *y) const;
		unsigned _xy2buffer(unsigned y, unsigned x) const;
		unsigned _x2line(unsigned x, const string&) const;
		unsigned _line2x(unsigned x, const string&) const;
		void _go2bufferpos(unsigned);	// place cursor at buffer position
		
		void _calculate_sliders();

		// invalidate line on the screen		
		void _invalidate_line(unsigned);
		
		// void invalidate_cursor();
};

#endif