/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/thread.hh>
#include <X11/Xlib.h>

#ifdef __TOAD_THREADS

#include <signal.h>

static pthread_key_t who_am_i;
static pthread_t main_thread;

// SIGIO is used by TOAD to wakeup the main thread in `TOADBase::SendMessage'
static void sig_io(int)
{
}

#endif

void TOADBase::InitThreads()
{
#ifdef __TOAD_THREADS

#if 0
	if (!XInitThreads())
		cerr << "toad: XInitThreads failed, better update your Xlib\n";
#endif
	
	#ifdef _MIT_POSIX_THREADS
	pthread_init();
	#endif
	
	pthread_key_create(&who_am_i, NULL);
	pthread_setspecific(who_am_i, NULL);
	main_thread = pthread_self();

	struct sigaction sa;
	sa.sa_handler = sig_io;
	sigemptyset(&sa.sa_mask);
	sa.sa_flags   = 0;
	sa.sa_restorer= NULL; // obsolete
	sigaction(SIGUSR1, &sa, NULL);

//	cout << "toad: POSIX threads initialized..." << endl;
#endif
}

#ifdef __TOAD_THREADS

TThread::~TThread()
{
}

void TThread::Join()
{
	void* dummy;
	pthread_join(_thread, &dummy);
}

void TThread::Start()
{
	pthread_create(&_thread, NULL, _thread_entry, (void*)this);
}

TThread* TThread::WhoAmI()
{
	return (TThread*) pthread_getspecific(who_am_i);
}

int TThread::Kill(TThread *thread, int sig)
{
	if (thread==NULL) {
		return pthread_kill(main_thread, sig);
	} else {
		return pthread_kill(thread->_thread, sig);
	}
}

void* TThread::_thread_entry(void *obj)
{
	pthread_setspecific(who_am_i, obj);
	((TThread*)obj)->main();
	// pthread_exit(NULL);
	return NULL;
}

#endif
