/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-2000 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TOADBase
#define TOADBase TOADBase

// TOAD version codes
//-----------------------------------------------
#define __TOAD__				1

#define __TOAD_MAJOR__  0
#define __TOAD_MINOR__	42
#define __TOAD_SUBLVL__ 22

#define TOAD_VERSION(A,B,C) __TOAD_MAJOR__==A && __TOAD_MINOR__==B && __TOAD_SUBLVL__==C

// hiding X11 types
//-----------------------------------------------
#ifdef _TOAD_PRIVATE
	typedef GC _TOAD_GC;
	typedef Drawable _TOAD_DRAWABLE;
	typedef Window _TOAD_WINDOW;
#else
	typedef void* _TOAD_GC;
	typedef unsigned long _TOAD_DRAWABLE;
	typedef unsigned long _TOAD_WINDOW;
#endif

#include <stdlib.h>
#include <stdio.h>

// ANSI headers needed everywhere in TOAD
//-----------------------------------------------
#include <typeinfo>
#include <stdexcept>
#include <iostream>
#include <string>

#include <toad/types.hh>
#include <toad/debug.hh>
#include <toad/config.h>
#include <toad/X11/keyboard.hh>
#include <toad/thread.hh>
#include <toad/connect.hh>

// this was part of TOAD some versions ago but i'm going
// to introduce it again
#define TOAD_XLIB_MTLOCK()
#define TOAD_XLIB_MTUNLOCK()

// MessageBox
//-----------------------------------------------
// remains from the old M$ Windows port...

#define MB_ICONEXCLAMATION		TMessageBox::ICON_EXCLAMATION
#define MB_ICONHAND						TMessageBox::ICON_HAND 
#define MB_ICONSTOP						TMessageBox::ICON_STOP
#define MB_ICONINFORMATION		TMessageBox::ICON_INFORMATION
#define MB_ICONQUESTION				TMessageBox::ICON_QUESTION

#define MB_ABORTRETRYIGNORE		(2+8+128)
#define MB_OK									4
#define MB_OKCANCEL						(4+64)
#define MB_RETRYCANCEL				(8+64)
#define MB_YESNO							(16+32)
#define MB_YESNOCANCEL				(16+32+64)

#define IDACCEPT	TMessageBox::ACCEPT
#define IDABORT		TMessageBox::ABORT
#define IDOK 			TMessageBox::OK
#define IDRETRY 	TMessageBox::RETRY
#define IDYES 		TMessageBox::YES
#define IDNO 			TMessageBox::NO
#define IDCANCEL 	TMessageBox::CANCEL
#define IDIGNORE 	TMessageBox::IGNORE

#define MB_DEFBUTTON1					TMessageBox::BUTTON1
#define MB_DEFBUTTON2					TMessageBox::BUTTON2
#define MB_DEFBUTTON3					TMessageBox::BUTTON3

int ToadMain();

class TWindow;
class TBitmap;
class TSignal;
class TFont;
class TDnDObject;
class TDialog;
class TDialogEditor;

class TOADBase
{
		friend TWindow;
		static bool lock_paint_queue;
		static class TFont *default_font;

	public:
		static class TFont* bold_font;
		virtual ~TOADBase();
		static int argc;
		static char **argv, **envv;
	
		static TWindow* twMainWindow;
		static bool bAppIsRunning;
		static TWindow* wndTopPopup;
		static bool bSimulatedAutomaticGrab;
		static TFont& DefaultFont(){
			if (!default_font) {
				cerr << "no default font" << endl;
				exit(1);
			}
			return *default_font;
		}
		static void SetDefaultFont(TFont*);
		static void SetColorLimit(unsigned);
		static void SetResourcePrefix(const string &);
		static const string& ResourcePrefix();

		// `class constructor/destructor'
		//-------------------------------
		static bool Init(int argc,char *argv[],char *envv[]);
		static void Close();
		static void InitColor();
		static void InitIO(int);
		static void InitThreads();
		static void InitXInput();
		static void InitDnD();
		static void Select();
		
		static void CloseXInput();

		// focus management
		//------------------
	private:
		static void FocusNewWindow(TWindow* wnd);
		static void FocusDelWindow(TWindow* wnd);
		static void DomainToWindow(TWindow *wnd);
		static void KeyDown(TKey key, char* t, unsigned m);
		static void KeyUp(TKey key, char* t, unsigned m);
		public:
		static TWindow* FocusWindow();
		static void SetFocusWindow(TWindow* wnd);

		// without category
		//------------------
		static int Run(TWindow *wnd, int argc=0, char** argv=NULL,char** envv=NULL);

		enum EWindowPlacement {
			PLACE_SCREEN_CENTER,
			PLACE_SCREEN_RANDOM,
			PLACE_PARENT_CENTER,
			PLACE_PARENT_RANDOM,
			PLACE_MOUSE_POINTER,
			PLACE_PULLDOWN,
			PLACE_TOOLTIP
		};
		static void PlaceWindow(TWindow *window, EWindowPlacement how, TWindow *parent=NULL);

		static unsigned MessageBox(TWindow* parent, 
															 const string& title,
															 const string &text, 
															 ulong type, 
															 TBitmap *bmp=NULL,
															 EWindowPlacement placement=PLACE_PARENT_CENTER);
		static void PostQuitMessage(int);
		static void Flush();

		static const string& ExecutablePath();
		static const string& ExecutableName();

		static void Bell(int volume = 0, int frequency=-1);

		// message handling
		//------------------
		static void SendMessage(TAction*);
		static void RemoveMessage(void*);
		static void RemoveAllIntMsg();

		static bool PeekMessage();
		static bool HandleMessage();

		static void LockPaintQueue() { lock_paint_queue = true; }
		static void UnlockPaintQueue() { lock_paint_queue = false; }
		
		// dialog administration
		//-----------------------
		static void EndDialog(TWindow*);
	
		// modal dialog administration
		//-----------------------------
		static void PushModal(TWindow *wnd);
		static void PopModal(TWindow *wnd);
		static void DoModal(TWindow *wnd);
		static void EndAllModal();
	
		// modeless dialog administration
		//--------------------------------
		static void DoModeless(TDialog *wnd);
		static void EndAllModeless();

		static int ScreenWidth();
		static int ScreenHeight();
		static void GetMousePos(int*,int*);
		static void SetMousePos(int,int);

	private:
		// tooltip support (implemented in tooltip.cc)
		//--------------------------------------------
		static void ToolTipOpen(TWindow*);
		static void ToolTipClose();

		// drag'n drop support (implemented in dragndrop.cc)
		//--------------------------------------------
	public:
		static void StartDrag(TDnDObject *obj, unsigned modifier = 0);
		static string GetSelection();

	private:
	#ifdef _TOAD_PRIVATE
		static void DnDNewShellWindow(TWindow*);
		static bool DnDMotionNotify(XEvent &event);
		static bool DnDButtonRelease(XEvent &event);
		static bool DnDClientMessage(XEvent &event);
		static bool DnDSelectionNotify(XEvent &event);
		static bool DnDSelectionRequest(XEvent &event);
		static bool DnDSelectionClear(XEvent &event);

	public:
		static Display *x11display;
		static Colormap x11colormap;
		static Visual* x11visual;
		static int x11depth;
		static XEvent x11event;
		static _TOAD_GC x11gc;
		static int x11screen;
		static XContext nClassContext;

		// should be an array
		static Atom xaWMSaveYourself;
		static Atom xaWMDeleteWindow;
		static Atom xaWMMotifHints;
	  #endif
};


#endif
