/******************************************************************************
 JStdError.cc

	Constants for the most common errno values.  Functions returning these
	errors from libc functions should guarantee that the error returned
	reflects only that call.

	Copyright  1997 by John Lindal. All rights reserved.

 *****************************************************************************/

#include <JStdError.h>
#include <JString.h>
#include <jAssert.h>

// Types

const JCharacter* kJGeneralIO = "JGeneralIO";

const JCharacter* kJSegFault           = "JSegFault";
const JCharacter* kJNoProcessMemory    = "JNoProcessMemory";
const JCharacter* kJNoKernelMemory     = "JNoKernelMemory";
const JCharacter* kJMemoryNotReadable  = "JMemoryNotReadable";
const JCharacter* kJMemoryNotWriteable = "JMemoryNotWriteable";

const JCharacter* kJProgramNotAvailable = "JProgramNotAvailable";
const JCharacter* kJFileAlreadyExists   = "JFileAlreadyExists";
const JCharacter* kJFileDoesNotExist    = "JFileDoesNotExists";
const JCharacter* kJNameTooLong         = "JNameTooLong";
const JCharacter* kJFileBusy            = "JFileBusy";
const JCharacter* kJInvalidOpenMode     = "JInvalidOpenMode";

const JCharacter* kJAccessDenied       = "JAccessDenied";
const JCharacter* kJFileSystemReadOnly = "JFileSystemReadOnly";
const JCharacter* kJFileSystemFull     = "JFileSystemFull";
const JCharacter* kJDeviceFull         = "JDeviceFull";

const JCharacter* kJComponentNotDirectory  = "JComponentNotDirectory";
const JCharacter* kJPathContainsLoop       = "JPathContainsLoop";
const JCharacter* kJDirectoryAlreadyExists = "JDirectoryAlreadyExists";
const JCharacter* kJBadPath                = "JBadPath";
const JCharacter* kJDirectoryNotEmpty      = "JDirectoryNotEmpty";
const JCharacter* kJDirectoryBusy          = "JDirectoryBusy";

const JCharacter* kJCantRenameFileToDirectory     = "JCantRenameFileToDirectory";
const JCharacter* kJCantRenameAcrossFilesystems   = "JCantRenameAcrossFilesystems";
const JCharacter* kJCantRenameToNonemptyDirectory = "JCantRenameToNonemptyDirectory";
const JCharacter* kJDirectoryCantBeOwnChild       = "JDirectoryCantBeOwnChild";
const JCharacter* kJTooManyLinks                  = "JTooManyLinks";

const JCharacter* kJTriedToRemoveDirectory = "JTriedToRemoveDirectory";
const JCharacter* kJIsADirectory           = "JIsADirectory";

const JCharacter* kJDescriptorNotOpen      = "JDescriptorNotOpen";
const JCharacter* kJTooManyDescriptorsOpen = "JTooManyDescriptorsOpen";
const JCharacter* kJNegativeDescriptor     = "JNegativeDescriptor";
const JCharacter* kJInvalidDescriptor      = "JInvalidDescriptor";

const JCharacter* kJWouldHaveBlocked = "JWouldHaveBlocked";
const JCharacter* kJNonBlockedSignal = "JNonBlockedSignal";

const JCharacter* kJNotCompressed = "JNotCompressed";

// Messages

const JCharacter* kJGeneralIOMsg =
	"A general I/O error (errno EIO) occured.";


const JCharacter* kJSegFaultMsg =
	"Recoverable segmentation fault: the programmer screwed up!";

const JCharacter* kJNoProcessMemoryMsg =
	"There is not enough free memory to complete the operation.";

const JCharacter* kJNoKernelMemoryMsg =
	"There is not enough free memory for the kernel to complete the operation."
	"  (Your computer is in big trouble!)";

const JCharacter* kJMemoryNotReadableMsg =
	"An attempt was made to read from memory without read permission.";

const JCharacter* kJMemoryNotWriteableMsg =
	"An attempt was made to write to memory without write permission.";


const JCharacter* kJFileAlreadyExistsMsg =
	"The specified file cannot be created because it already exists.";

const JCharacter* kJFileDoesNotExistMsg =
	"The specified file does not exist.";

const JCharacter* kJNameTooLongMsg =
	"The specified pathname is too long.";

const JCharacter* kJFileBusyMsg =
	"The file cannot be replaced because it is being used by another program.";

const JCharacter* kJInvalidOpenModeMsg =
	"The requested method of opening the file is invalid.";


const JCharacter* kJAccessDeniedMsg =
	"You are not allowed to access the specified file or directory.";

const JCharacter* kJFileSystemReadOnlyMsg =
	"You cannot write to a read-only file system.";

const JCharacter* kJFileSystemFullMsg =
	"The file system does not have enough free space left.";

const JCharacter* kJDeviceFullMsg =
	"A write was attempted to a device with insufficient room to accept the data.";


const JCharacter* kJComponentNotDirectoryMsg =
	"Some part of the specified path is not a directory.";

const JCharacter* kJPathContainsLoopMsg =
	"The specified path contains a loop caused by symbolic links.";

const JCharacter* kJDirectoryAlreadyExistsMsg =
	"The specified directory cannot be created because it already exists.";

const JCharacter* kJBadPathMsg =
	"The specified path is invalid.";

const JCharacter* kJDirectoryNotEmptyMsg =
	"The directory cannot be removed because it is not empty.";

const JCharacter* kJDirectoryBusyMsg =
	"The directory cannot be removed because it is being used by another program.";


const JCharacter* kJCantRenameFileToDirectoryMsg =
	"You cannot rename a file to a name that is already a directory";

const JCharacter* kJCantRenameAcrossFilesystemsMsg =
	"You cannot rename a file so that it moves to a different file system.";

const JCharacter* kJCantRenameToNonemptyDirectoryMsg =
	"You cannot rename a directory to an existing, non-empty directory.";

const JCharacter* kJDirectoryCantBeOwnChildMsg =
	"A directory cannot be renamed so that it becomes a sub-directory of itself.";

const JCharacter* kJTooManyLinksMsg =
	"Renaming the specified file or directory would exceed the maximum allowed "
	"number of file system links.";


const JCharacter* kJTriedToRemoveDirectoryMsg =
	"remove() can only remove files, not directories.";

const JCharacter* kJIsADirectoryMsg =
	"An operation which is only legal on a file was attempted on a directory.";


const JCharacter* kJDescriptorNotOpenMsg =
    "At least one of the file descriptors does not refer to an open file.";

const JCharacter* kJTooManyDescriptorsOpenMsg =
	"The program is not allowed to open any more files.";

const JCharacter* kJNegativeDescriptorMsg =
	"At least one of the file descriptors is negative.";

const JCharacter* kJInvalidDescriptorMsg =
	"At least one of the file descriptors was invalid.";


const JCharacter* kJWouldHaveBlockedMsg =
	"The requested operation would have blocked and the stream is set to non-blocking.";

const JCharacter* kJNonBlockedSignalMsg =
	"A non-blocked signal was received which interrupted the operation.";


const JCharacter* kJNotCompressedMsg =
	"The specified file is not compressed.";

/******************************************************************************
 JProgramNotAvailable

 *****************************************************************************/

static const JCharacter* kJProgramNotAvailableMsg =
	"\" either does not exist or "
	"is not in any of the directories on the current execution path.";

JProgramNotAvailable::JProgramNotAvailable
	(
	const JCharacter* programName
	)
	:
	JError(kJProgramNotAvailable, kJProgramNotAvailableMsg)
{
	JString msg = "\"";
	msg += programName;
	msg += kJProgramNotAvailableMsg;
	SetMessage(msg, kTrue);
}
