#ifndef _H_JStringMap
#define _H_JStringMap

/******************************************************************************
 JStringMap.h

	Interface for the JStringMap template.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

// Superclass header
#include <JHashTable.h>

#include <jTypes.h>

#include <JStringMapCursor.h>
#include <JHashCursor.h>
#include <JStrValue.h>


struct JStringMapT
{
	enum SetType
	{
		kIfNew, // Only set if the element already exists
		kIfOld, // Only set if the element does not already exist
		kAlways // Always set the element
	};
};

template <class V>
class JStringMap : public JHashTable< JStrValue<V> >
{
	friend class JStringMapCursor<V>;

public:

	JStringMap(const JBoolean copyKeys);
	JStringMap(const JSize lgSize = kJDefaultLgMinTableSize, const JBoolean copyKeys = kTrue);
	virtual ~JStringMap();

	JBoolean SetElement(const JCharacter* const key, const V& value,
	                    const JStringMapT::SetType type = JStringMapT::kAlways);
	JBoolean SetNewElement(const JCharacter* const key, const V& value);
	JBoolean SetOldElement(const JCharacter* const key, const V& value);
	JBoolean SetContains(const JCharacter* const key, const V& value);

	JBoolean GetElement(const JCharacter* const key, V* value) const;

	JBoolean Contains(const JCharacter* const key) const;

	JBoolean RemoveElement(const JCharacter* const key);
	void     RemoveAll();

	JBoolean KeysAreCopied() const { return itsCopyKeysFlag; };

private:

	const JBoolean itsCopyKeysFlag;

private:

	static JBoolean Compare(const JStrValue<V>& lhs, const JStrValue<V>& rhs);

	static JHashValue Hash(const JStrValue<V>& value);

	// not allowed

	JStringMap(const JStringMap& source);
	const JStringMap& operator=(const JStringMap& source);
};

/******************************************************************************
 SetNewElement

	Only sets the value if it does not already exist.  Returns kTrue if the
	value was set.

 *****************************************************************************/

template <class V>
inline JBoolean
JStringMap<V>::SetNewElement
	(
	const JCharacter* const key,
	const V& value
	)
{
	return SetElement(key, value, JStringMapT::kIfNew);
}

/******************************************************************************
 SetOldElement

	Only sets the value if it already exists.  Returns kTrue if the value was
	set.

 *****************************************************************************/

template <class V>
inline JBoolean
JStringMap<V>::SetOldElement
	(
	const JCharacter* const key,
	const V& value
	)
{
	return SetElement(key, value, JStringMapT::kIfOld);
}

#endif
