/******************************************************************************
 jUNIXUtil.h

	Interface for jUNIXUtil.cc

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_jUNIXUtil
#define _H_jUNIXUtil

#include <JError.h>
#include <ace/OS.h>
#include <unistd.h>

#ifdef __MWERKS__
	typedef unsigned long uid_t;
	typedef unsigned long gid_t;
#else
	#include <sys/types.h>
#endif

class JString;

JString JGetHostName();

JString JGetUserName();
JString JGetUserName(const uid_t uid);

JString JGetUserRealWorldName();
JString JGetUserRealWorldName(const uid_t uid);

JString JGetGroupName();
JString JGetGroupName(const gid_t gid);

JBoolean JUNIXSocketExists(const JCharacter* pathName);

JError JCreatePipe(ACE_HANDLE fd[2]);

#endif
