/******************************************************************************
 JXPTPageSetupDialog.h

	Interface for the JXPTPageSetupDialog class

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXPTPageSetupDialog
#define _H_JXPTPageSetupDialog

#include <JXDialogDirector.h>

class JXPTPrinter;
class JXTextButton;
class JXInputField;
class JXIntegerInput;

class JXPTPageSetupDialog : public JXDialogDirector
{
public:

	JXPTPageSetupDialog();

	virtual ~JXPTPageSetupDialog();

	void	BuildWindow(const JCharacter* printCmd,
						const JSize pageWidth, const JSize pageHeight,
						const JSize minPageHeight);

	JBoolean	SetParameters(JXPTPrinter* p) const;

protected:

	void	SetObjects(JXTextButton* okButton, JXTextButton* cancelButton,
					   JXInputField* printCmdInput, const JCharacter* printCmd,
					   JXIntegerInput* widthInput, const JSize pageWidth,
					   JXIntegerInput* heightInput, const JSize pageHeight,
					   const JSize minPageHeight, JXTextButton* printTestButton);

	JXIntegerInput*	GetWidthInput() const;
	JXIntegerInput*	GetHeightInput() const;

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

// begin JXLayout

    JXInputField*   itsPrintCmd;
    JXIntegerInput* itsWidth;
    JXIntegerInput* itsHeight;
    JXTextButton*   itsPrintTestButton;

// end JXLayout

private:

	void	PrintTestPage();

	// not allowed

	JXPTPageSetupDialog(const JXPTPageSetupDialog& source);
	const JXPTPageSetupDialog& operator=(const JXPTPageSetupDialog& source);
};


/******************************************************************************
 Get input fields (protected)

	These are provided so derived classes can adjust the limits.

 ******************************************************************************/

inline JXIntegerInput*
JXPTPageSetupDialog::GetWidthInput()
	const
{
	return itsWidth;
}

inline JXIntegerInput*
JXPTPageSetupDialog::GetHeightInput()
	const
{
	return itsHeight;
}

#endif
