/******************************************************************************
 JXPathHistoryMenu.cc

	Maintains a fixed-length list of paths.  When the menu needs to be
	updated, non-existent directories are removed.

	BASE CLASS = JXStringHistoryMenu

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXPathHistoryMenu.h>
#include <jXCSFIcons.h>
#include <jDirUtil.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXPathHistoryMenu::JXPathHistoryMenu
	(
	const JSize			historyLength,
	const JCharacter*	title,
	JXContainer*		enclosure,
	const HSizingOption	hSizing,
	const VSizingOption	vSizing,
	const JCoordinate	x,
	const JCoordinate	y,
	const JCoordinate	w,
	const JCoordinate	h
	)
	:
	JXStringHistoryMenu(historyLength, title, enclosure, hSizing, vSizing, x,y, w,h)
{
	JXPathHistoryMenuX();
}

JXPathHistoryMenu::JXPathHistoryMenu
	(
	const JSize		historyLength,
	JXMenu*			owner,
	const JIndex	itemIndex,
	JXContainer*	enclosure
	)
	:
	JXStringHistoryMenu(historyLength, owner, itemIndex, enclosure)
{
	JXPathHistoryMenuX();
}

// private

void
JXPathHistoryMenu::JXPathHistoryMenuX()
{
	JXImage* icon = new JXImage(GetDisplay(), GetColormap(), JXGetFolderIcon());
	assert( icon != NULL );
	SetDefaultIcon(icon, kTrue);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXPathHistoryMenu::~JXPathHistoryMenu()
{
}

/******************************************************************************
 SetBasePath

	This is used if a relative path is stored.  It must be an absolute path.

 ******************************************************************************/

void
JXPathHistoryMenu::SetBasePath
	(
	const JCharacter* path
	)
{
	assert( path != NULL && path[0] == '/' );
	itsBasePath = path;
}

/******************************************************************************
 UpdateMenu (virtual protected)

 ******************************************************************************/

void
JXPathHistoryMenu::UpdateMenu()
{
	RemoveInvalidPaths();
	JXStringHistoryMenu::UpdateMenu();
}

/******************************************************************************
 RemoveInvalidPaths (private)

 ******************************************************************************/

void
JXPathHistoryMenu::RemoveInvalidPaths()
{
	JString fullName;

	const JSize count = GetItemCount();
	for (JIndex i=count; i>=1; i--)
		{
		const JString& dirName = GetItemText(i);
		if (!JConvertToAbsolutePath(dirName, itsBasePath, &fullName))
			{
			DeleteItem(i);
			}
		}
}
