/******************************************************************************
 JXStyleTableMenu.cc

	Menu for changing font styles in a JXStyleTable.  This menu is an action
	menu, so all messages that are broadcast are meaningless to outsiders.

	BASE CLASS = JXStyleMenu

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXStyleTableMenu.h>
#include <JXStyleTable.h>
#include <jAssert.h>

/******************************************************************************
 Create (static)

	Work-around for egcs thunks bug.

 ******************************************************************************/

JXStyleTableMenu*
JXStyleTableMenu::Create
	(
	JXStyleTable*		table,
	const JXMenu::Style	menuStyle,
	JXContainer*		enclosure,
	const HSizingOption	hSizing,
	const VSizingOption	vSizing,
	const JCoordinate	x,
	const JCoordinate	y,
	const JCoordinate	w,
	const JCoordinate	h
	)
{
	JXStyleTableMenu* menu =
		new JXStyleTableMenu(table, menuStyle, enclosure, hSizing, vSizing, x,y, w,h);
	assert( menu != NULL );
	menu->JXStyleMenuX(menuStyle);
	return menu;
}

JXStyleTableMenu*
JXStyleTableMenu::Create
	(
	JXStyleTable*		table,
	const JXMenu::Style	menuStyle,
	JXMenu*				owner,
	const JIndex		itemIndex,
	JXContainer*		enclosure
	)
{
	JXStyleTableMenu* menu =
		new JXStyleTableMenu(table, menuStyle, owner, itemIndex, enclosure);
	assert( menu != NULL );
	menu->JXStyleMenuX(menuStyle);
	return menu;
}

/******************************************************************************
 Constructor (protected)

 ******************************************************************************/

JXStyleTableMenu::JXStyleTableMenu
	(
	JXStyleTable*		table,
	const JXMenu::Style	menuStyle,
	JXContainer*		enclosure,
	const HSizingOption	hSizing,
	const VSizingOption	vSizing,
	const JCoordinate	x,
	const JCoordinate	y,
	const JCoordinate	w,
	const JCoordinate	h
	)
	:
	JXStyleMenu(menuStyle, kFalse, enclosure, hSizing, vSizing, x,y, w,h)
{
	itsTable = table;
}

JXStyleTableMenu::JXStyleTableMenu
	(
	JXStyleTable*		table,
	const JXMenu::Style	menuStyle,
	JXMenu*				owner,
	const JIndex		itemIndex,
	JXContainer*		enclosure
	)
	:
	JXStyleMenu(menuStyle, kFalse, owner, itemIndex, enclosure)
{
	itsTable = table;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXStyleTableMenu::~JXStyleTableMenu()
{
}

/******************************************************************************
 UpdateMenu (virtual protected)

	We are only active if a cell is being edited.

 ******************************************************************************/

void
JXStyleTableMenu::UpdateMenu()
{
	if (itsTable->IsEditing())
		{
		EnableAll();
		JXStyleMenu::UpdateMenu();
		}
}

/******************************************************************************
 GetFontStyleForMenuUpdate (virtual protected)

 ******************************************************************************/

JFontStyle
JXStyleTableMenu::GetFontStyleForMenuUpdate()
	const
{
	JPoint cell;
	const JBoolean ok = itsTable->GetEditedCell(&cell);
	assert( ok );
	return itsTable->GetCellStyle(cell);
}

/******************************************************************************
 HandleMenuItem (virtual protected)

 ******************************************************************************/

void
JXStyleTableMenu::HandleMenuItem
	(
	const JIndex index
	)
{
	JPoint cell;
	if (itsTable->GetEditedCell(&cell))
		{
		JFontStyle style = itsTable->GetCellStyle(cell);
		UpdateStyle(index, &style);
		itsTable->SetCellStyle(cell, style);
		}
}
