/******************************************************************************
 TestChooseSaveFile.cc

	Class to test overriding of JXChooseSaveFile dialog windows.

	BASE CLASS = JXChooseSaveFile

	Written by John Lindal.

 ******************************************************************************/

#include "TestChooseSaveFile.h"
#include "TestSaveFileDialog.h"
#include <JUNIXDirInfo.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

TestChooseSaveFile::TestChooseSaveFile()
	:
	JXChooseSaveFile()
{
	itsTestSaveDialog = NULL;
	itsSaveFormat     = kGIFFormat;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

TestChooseSaveFile::~TestChooseSaveFile()
{
}

/******************************************************************************
 CreateSaveFileDialog (virtual protected)

 ******************************************************************************/

JXSaveFileDialog*
TestChooseSaveFile::CreateSaveFileDialog
	(
	JXDirector*			supervisor,
	JUNIXDirInfo*		dirInfo,
	const JCharacter*	fileFilter,
	const JCharacter*	origName,
	const JCharacter*	prompt,
	const JCharacter*	message
	)
{
	itsTestSaveDialog =
		new TestSaveFileDialog(supervisor, dirInfo, fileFilter, itsSaveFormat);
	assert( itsTestSaveDialog != NULL );
	itsTestSaveDialog->BuildWindow(origName, prompt, message);
	return itsTestSaveDialog;
}

/******************************************************************************
 GetSaveFormat

 ******************************************************************************/

TestChooseSaveFile::SaveFormat
TestChooseSaveFile::GetSaveFormat()
	const
{
	return itsSaveFormat;
}

/******************************************************************************
 Receive (virtual protected)

	Listen for response from itsTestSaveDialog.

 ******************************************************************************/

void
TestChooseSaveFile::Receive
	(
	JBroadcaster*	sender,
	const Message&	message
	)
{
	if (sender == itsTestSaveDialog && message.Is(JXDialogDirector::kDeactivated))
		{
		const JXDialogDirector::Deactivated* info =
			dynamic_cast(const JXDialogDirector::Deactivated*, &message);
		assert( info != NULL );
		if (info->Successful())
			{
			itsSaveFormat = itsTestSaveDialog->GetSaveFormat();
			}
		itsTestSaveDialog = NULL;
		}

	JXChooseSaveFile::Receive(sender, message);
}

/******************************************************************************
 SetChooseFileContentFilter (virtual protected)

 ******************************************************************************/

void
TestChooseSaveFile::SetChooseFileContentFilter
	(
	JUNIXDirInfo* dirInfo
	)
{
	dirInfo->SetContentFilter("(^[[:space:]]*$)|(^[[:space:]]*From )");
}
