/*
 Copyright (C) 2000 David L. Rose

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include "xgauge.h"

Application *app;


// ****************** Fallbacks **************************
static _XtString fallbacks[] = {
    "*theForm*FontList:   -adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*",
    "*theForm*verBottom*FontList: -adobe-helvetica-*-r-*-*-10-*-*-*-*-*-*-*",
    "*theForm*verTop*FontList: -adobe-helvetica-*-r-*-*-14-*-*-*-*-*-*-*",
    "*theForm*horLeft*FontList: -adobe-helvetica-*-r-*-*-18-*-*-*-*-*-*-*",
    "*theForm*horRight*FontList: -adobe-*-*-r-*-*-16-*-*-*-*-*-*-*",
    NULL   
};

// ******************** main ***************************
int
main (int argc, char **argv)
{

   // initialize application 
   app = new Application("gauge", argc, argv);

   // realize application
   app->realize();

   // start the main loop 
   app->mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out, fallbacks)
{

   title("Gauge Demo");

   // ******************** Main Window ***************
   main_window = new MainWindow("mainWindow", *this);


   // ******************** Form **********************
   args.reset();
   form = new Form(*main_window, args, "theForm");


   // ******************* Horizontal Slider ****************
   args.reset();
   args(XmNtopOffset,                       10)
       (XmNbottomOffset,                    10)
       (XmNrightOffset,                     10)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                        100)
       (XmNvalue,                            0)
       (XmNorientation,           XmHORIZONTAL)
       (XmNprocessingDirection, XmMAX_ON_RIGHT)
       (XmNbottomAttachment,     XmATTACH_FORM)
       (XmNleftAttachment,       XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_POSITION)
       (XmNrightPosition,                   50);

   hor_slider = new Scale(*form, args, "horSlider");

   // ******************* Vertical Slider ****************
   args.reset();
   args(XmNtopOffset,                       10)
       (XmNbottomOffset,                    10)
       (XmNrightOffset,                     10)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                       2000)
       (XmNvalue,                            0)
       (XmNorientation,           XmHORIZONTAL)
       (XmNprocessingDirection, XmMAX_ON_RIGHT)
       (XmNbottomAttachment,     XmATTACH_FORM)
       (XmNleftAttachment,   XmATTACH_POSITION)
       (XmNleftPosition,                    50)
       (XmNrightAttachment,      XmATTACH_FORM);

   ver_slider = new Scale(*form, args, "verSlider");

   // ******************* Horizontal/Left gauge ******
   args.reset();
   args(XmNgaugeMargin,                      0)  
       (XmNshowValue,                     True)  
       (XmNshowMinMax,                   False)  
       (XmNshowPercentage,                True)  
     //(XmNhighlightThickness,               0)  
     //(XmNshadowThickness,                  0)  
       (XmNsliderShadowThickness,            8) 
       (XmNtroughShadowThickness,            5)  
       (XmNforeground,   XmRString, "white", 5)
       (XmNsliderColor,  XmRString, "green", 5)  
       (XmNtopOffset,                       10)
       (XmNbottomOffset,                     0)
       (XmNrightOffset,                      0)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                        100) 
       (XmNvalue,                            0)
       (XmNorientation,           XmHORIZONTAL)
       (XmNprocessingDirection,  XmMAX_ON_LEFT)
       (XmNtopAttachment,        XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_POSITION)
       (XmNbottomPosition,                  15)          
       (XmNleftAttachment,       XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_POSITION)
       (XmNrightPosition,                   80);

   hor_left = new Gauge(*form, args, "horLeft");


   // ******************* Horizontal/Right gauge *****
   args.reset();
   args(XmNgaugeMargin,                      0)  
       (XmNshowValue,                     True)  
       (XmNshowMinMax,                    True)  
       (XmNshowPercentage,               False)  
     //(XmNhighlightThickness,               0)  
     //(XmNshadowThickness,                  5)  
       (XmNsliderShadowThickness,            2)  
       (XmNtroughShadowThickness,            0)  
       (XmNforeground,   XmRString, "white", 5)
       (XmNsliderColor,   XmRString, "blue", 4)  
       (XmNtopOffset,                        0)
       (XmNbottomOffset,                    10)
       (XmNrightOffset,                     10)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                        100) 
       (XmNvalue,                            0)
       (XmNorientation,           XmHORIZONTAL)
       (XmNprocessingDirection, XmMAX_ON_RIGHT)
       (XmNtopAttachment,    XmATTACH_POSITION)
       (XmNtopPosition,                     80) 
       (XmNbottomAttachment,   XmATTACH_WIDGET)  
       (XmNbottomWidget,            hor_slider)        
       (XmNleftAttachment,   XmATTACH_POSITION)
       (XmNleftPosition,                    20)
       (XmNrightAttachment,      XmATTACH_FORM);


   hor_right = new Gauge(*form, args, "horRight");


   // ******************* Vertical/Top gauge ********
   args.reset();
   args(XmNgaugeMargin,                      5)  
       (XmNshowValue,                     True)  
       (XmNshowMinMax,                   False)  
       (XmNshowPercentage,               False)  
     //(XmNhighlightThickness,               0)  
     //(XmNshadowThickness,                  0)  
       (XmNsliderShadowThickness,            0)  
       (XmNtroughShadowThickness,            0)  
       (XmNforeground,    XmRString, "blue", 4)
       (XmNsliderColor, XmRString, "yellow", 6)  
       (XmNtopOffset,                       10)
       (XmNbottomOffset,                    10)
       (XmNrightOffset,                      0)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                       2000) 
       (XmNvalue,                            0)
       (XmNorientation,             XmVERTICAL)
       (XmNprocessingDirection,   XmMAX_ON_TOP)
       (XmNtopAttachment,    XmATTACH_POSITION)
       (XmNtopPosition,                     15) 
       (XmNbottomAttachment,   XmATTACH_WIDGET)
       (XmNbottomWidget,            ver_slider)          
       (XmNleftAttachment,       XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_POSITION)
       (XmNrightPosition,                   20);

   ver_top = new Gauge(*form, args, "verTop");


   // ******************* Vertical/Bottom gauge *****
   args.reset();
   args(XmNgaugeMargin,                      0)  
       (XmNshowValue,                     True)  
       (XmNshowMinMax,                    True)  
       (XmNshowPercentage,                True)  
     //(XmNhighlightThickness,               0)  
       (XmNshadowThickness,                  5)  
       (XmNsliderShadowThickness,            0)  
       (XmNtroughShadowThickness,            5)  
       (XmNforeground,   XmRString, "white", 5)
       (XmNsliderColor,XmRString, "darkred", 7)  
       (XmNtopOffset,                       10)
       (XmNbottomOffset,                    10)
       (XmNrightOffset,                     10)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                       2000) 
       (XmNvalue,                            0)
       (XmNorientation,             XmVERTICAL)
       (XmNprocessingDirection,XmMAX_ON_BOTTOM)
       (XmNtopAttachment,        XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_POSITION) 
       (XmNbottomPosition,                  80)         
       (XmNleftAttachment,   XmATTACH_POSITION)
       (XmNleftPosition,                    80)
       (XmNrightAttachment,      XmATTACH_FORM);

   ver_bottom = new Gauge(*form, args, "verBottom");


   // ******************* Horizontal/Middle gauge *****

   weave = XCreatePixmapFromBitmapData(this->display(),
           RootWindow(this->display(), 0),
           cross_weave_bits,
           cross_weave_width,
           cross_weave_height,
           BlackPixel(this->display(), 0),
           WhitePixel(this->display(), 0),
           DefaultDepth(this->display(), 0));

   args.reset();
   args(XmNgaugeMargin,                      0)  
       (XmNshowValue,                     True)  
       (XmNshowMinMax,                    True)  
       (XmNshowPercentage,                True)  
     //(XmNhighlightThickness,               0)  
     //(XmNshadowThickness,                  0)  
       (XmNsliderShadowThickness,            2)  
       (XmNtroughShadowThickness,            2) 
       (XmNsliderPixmap,                 weave) 
       (XmNforeground, XmRString, "darkred", 7)
       (XmNtopOffset,                       10)
       (XmNbottomOffset,                    10)
       (XmNrightOffset,                     10)
       (XmNleftOffset,                      10)
       (XmNminimum,                          0)
       (XmNmaximum,                        100) 
       (XmNvalue,                            0)
       (XmNorientation,           XmHORIZONTAL)
       (XmNprocessingDirection, XmMAX_ON_RIGHT)
       (XmNtopAttachment,    XmATTACH_POSITION)
       (XmNtopPosition,                     30)
       (XmNbottomAttachment, XmATTACH_POSITION) 
       (XmNbottomPosition,                  70)         
       (XmNleftAttachment,   XmATTACH_POSITION)
       (XmNleftPosition,                    30)
       (XmNrightAttachment,  XmATTACH_POSITION)
       (XmNrightPosition,                   70);

   hor_middle = new Gauge(*form, args, "horMiddle");

   // put the guys on the screen
   main_window->manage();
   form->manage();
   hor_slider->manage();
   ver_slider->manage();

   addCallback(this,
               &Application::hor_move,
               hor_slider,
               XmNvalueChangedCallback);
   addCallback(this,
               &Application::hor_move,
               hor_slider,
               XmNdragCallback);

   addCallback(this,
               &Application::ver_move,
               ver_slider,
               XmNvalueChangedCallback);
   addCallback(this,
               &Application::ver_move,
               ver_slider,
               XmNdragCallback);

}

void
Application::hor_move(Widget w, XtPointer, XtPointer)
{

    hor_left->value(hor_slider->value());
    hor_right->value(hor_slider->value());
    hor_middle->value(hor_slider->value());

}

void
Application::ver_move(Widget w, XtPointer, XtPointer)
{

    ver_top->value(ver_slider->value());
    ver_bottom->value(ver_slider->value());

}
