/*
 Copyright (C) 2000 David L. Rose

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/
#include <Xarm/AppContext.h>
#include <Xarm/ApplicationS.h>
#include <Xarm/Callback.h>
#include <Xarm/Form.h>
#include <Xarm/Gauge.h>
#include <Xarm/MainW.h>
#include <Xarm/Scale.h>
#include "cross_weave.xbm"


class Application: public AppContext
{

      MainWindow *main_window;
      Form *form;


      Gauge *hor_left;
      Gauge *hor_right;
      Gauge *ver_top;
      Gauge *ver_bottom;
      Gauge *hor_middle;
      Scale *hor_slider;
      Scale *ver_slider;

      Pixmap weave;
      XarmArg args;

    public:

      void hor_move(Widget, XtPointer, XtPointer);
      void ver_move(Widget, XtPointer, XtPointer);

      Application(char *app_class,int &argc_in_out, char **argv_in_out);

};

      extern Application *app;

