/* $Id: Property.h,v 1.1.1.1 2001/04/09 13:32:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_property_h)
#define xarm_property_h

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI and 
 * use widgets written by the author.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xmext/Property.h>
#include <Xarm/BulletinB.h>

class PropertySheetClass : public BulletinBoardClass {
 protected:
   PropertySheetClass() {} 
   virtual WidgetClass classPointer() { return xmPropertySheetWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPropertySheet"; }

 public:
   /* callbacks */
   /* activate callbacks for the following default buttons */
   void cancelCallback(XtCallbackProc fp, XtPointer data = NULL)   { XARM_SET_CALLBACK(XmNcancelCallback); }
   void okCallback(XtCallbackProc fp, XtPointer data = NULL)       { XARM_SET_CALLBACK(XmNokCallback); }
   void applyCallback(XtCallbackProc fp, XtPointer data = NULL)    { XARM_SET_CALLBACK(XmNapplyCallback); }

   /* resources */
   int pageCount() const                     { XARM_GET_VALUE(int, XmNpageCount); }
   void cancelLabelString(const char *str)   { XARM_SET_STRING(XmNcancelLabelString); }
   char *cancelLabelString() const           { XARM_GET_STRING(XmNcancelLabelString); }
   void okLabelString(const char *str)       { XARM_SET_STRING(XmNokLabelString); }
   char *okLabelString() const               { XARM_GET_STRING(XmNokLabelString); }
   void applyLabelString(const char *str)    { XARM_SET_STRING(XmNapplyLabelString); }
   char *applyLabelString() const            { XARM_GET_STRING(XmNapplyLabelString); }
   void helpLabelString(const char *str)     { XARM_SET_STRING(XmNhelpLabelString); }
   char *helpLabelString() const             { XARM_GET_STRING(XmNhelpLabelString); }

   /* convience routines */
   Widget getPage(int pos) const             { return XmPropertySheetGetPage(widget(), pos); }
   void addPage(Widget page, int loc = 0)    { XmPropertySheetAddPage(widget(), page, loc); }
   void removePage(int pos)                  { XmPropertySheetRemovePos(widget(), pos); }
   void removePage(Widget page)              { XmPropertySheetRemovePage(widget(), page); }

   Widget getChild(unsigned char ch) const   { return XmPropertySheetGetChild(widget(), ch); }

};

typedef XarmFuncWidget<PropertySheetClass, XmCreatePropertySheet, false>       PropertySheet;
typedef XarmFuncWidget<PropertySheetClass, XmCreatePropertySheetDialog, false> PropertySheetDialog;

#endif
