/* $Id: Separator.h,v 1.1.1.1 2001/04/09 13:33:16 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_separator_h)
#define xarm_separator_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xm/Separator.h>

class SeparatorClass : public PrimitiveClass {
 protected:
   SeparatorClass() {}
   virtual WidgetClass classPointer()  { return xmSeparatorWidgetClass; }
   virtual _XtString className()       { return (_XtString) "XmSeparator"; }
 public:
   /* resources */
   void margin(Dimension val)             { XARM_SET_VALUE(XmNmargin); }
   Dimension margin() const               { XARM_GET_VALUE(Dimension, XmNmargin); }
   void orientation(unsigned char val)    { XARM_SET_VALUE(XmNorientation); }
   unsigned char orientation() const      { XARM_GET_VALUE(unsigned char, XmNorientation); }
   void separatorType(unsigned char val)  { XARM_SET_VALUE(XmNseparatorType); }
   unsigned char separatorType() const    { XARM_GET_VALUE(unsigned char, XmNseparatorType); }
};

typedef XarmRawWidget<SeparatorClass, true> Separator;

#endif
