/* $Id: VendorS.h,v 1.1.1.1 2001/04/09 13:33:36 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Don't put the following include inside the if ... endif */
/* Include(s): */
#include <Xarm/Shell.h>
#include <Xm/VendorS.h>

#if !defined(xarm_vendors_h)
#define xarm_vendors_h

class VendorShellClass : public WMShellClass {
 protected:
   VendorShellClass() {}
   
   virtual WidgetClass classPointer() { return vendorShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "VendorShell"; }
 public:
   /* extra functionality */
   void deleteWindowCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void saveYourselfCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void takeFocusCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void audibleWarning(unsigned char val)        { XARM_SET_VALUE(XmNaudibleWarning); }
   unsigned char audibleWarning()                { XARM_GET_VALUE(unsigned char, XmNaudibleWarning); }
   XmFontList defaultFontList()                  { XARM_GET_VALUE(XmFontList, XmNdefaultFontList); }
   void deleteResponse(unsigned char val)        { XARM_SET_VALUE(XmNdeleteResponse); }
   unsigned char deleteResponse()                { XARM_GET_VALUE(unsigned char, XmNdeleteResponse); }
   void inputMethod(_XtString val)               { XARM_SET_VALUE(XmNinputMethod); }
   _XtString inputMethod()                       { XARM_GET_VALUE(_XtString, XmNinputMethod); }
   void keyboardFocusPolicy(unsigned char val)   { XARM_SET_VALUE(XmNkeyboardFocusPolicy); }
   unsigned char keyboardFocusPolicy()           { XARM_GET_VALUE(unsigned char, XmNkeyboardFocusPolicy); }
   void mwmDecorations(int val)                  { XARM_SET_VALUE(XmNmwmDecorations); }
   int mwmDecorations()                          { XARM_GET_VALUE(int, XmNmwmDecorations); }
   void mwmFunctions(int val)                    { XARM_SET_VALUE(XmNmwmFunctions); }
   int mwmFunctions()                            { XARM_GET_VALUE(int, XmNmwmFunctions); }
   void mwmInputMode(int val)                    { XARM_SET_VALUE(XmNmwmInputMode); }
   int mwmInputMode()                            { XARM_GET_VALUE(int, XmNmwmInputMode); }
   void mwmMenu(_XtString val)                   { XARM_SET_VALUE(XmNmwmMenu); }
   _XtString mwmMenu()                           { XARM_GET_VALUE(_XtString, XmNmwmMenu); }
   void preeditType(_XtString val)               { XARM_SET_VALUE(XmNpreeditType); }
   _XtString preeditType()                       { XARM_GET_VALUE(_XtString, XmNpreeditType); }
   void shellUnitType(unsigned char val)         { XARM_SET_VALUE(XmNshellUnitType); }
   unsigned char shellUnitType()                 { XARM_GET_VALUE(unsigned char, XmNshellUnitType); }
   void useAsyncGeometry(Boolean val)            { XARM_SET_VALUE(XmNuseAsyncGeometry); }
   Boolean useAsyncGeometry()                    { XARM_GET_VALUE(Boolean, XmNuseAsyncGeometry); }
};

#endif

