/*
 Copyright (C) 2001 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_xarminput_h)
#define xarm_xarminput_h

#include <Xarm/Xarm.h>

#ifdef XARM_XBAE_HAS_INPUT

#include <Xarm/Text.h>
#include <Xbae/Input.h>

class InputClass : public TextClass {

 protected:

    InputClass() {}

    virtual WidgetClass classPointer() { return xbaeInputWidgetClass; }
    virtual _XtString   className()    { return (_XtString) "XbaeInput"; }

 public:

    /* Callbacks */
    void validateCallback(XtCallbackProc fp, XtPointer data = NULL)
          { XARM_SET_CALLBACK(XmNvalidateCallback); }

    /* Resources */
    void           alignment(unsigned char val)   { XARM_SET_VALUE(XmNalignment); }
    unsigned char  alignment() const              { XARM_GET_VALUE(unsigned char, XmNalignment); }
    void           autoFill(Boolean val)          { XARM_SET_VALUE(XmNautoFill); }
    Boolean        autoFill() const               { XARM_GET_VALUE(Boolean, XmNautoFill); }
    void           convertCase(Boolean val)       { XARM_SET_VALUE(XmNconvertCase); }
    Boolean        convertCase() const            { XARM_GET_VALUE(Boolean, XmNconvertCase); }
    void           overwriteMode(Boolean val)     { XARM_SET_VALUE(XmNoverwriteMode); }
    Boolean        overwriteMode() const          { XARM_GET_VALUE(Boolean, XmNoverwriteMode); }
    void           pattern(String val)            { XARM_SET_VALUE(XmNpattern); }
    String         pattern() const                { XARM_GET_VALUE(String, XmNpattern); }

};

typedef XarmRawWidget<InputClass, true> Input;

#endif // XARM_XBAE_HAS_INPUT

#endif // xarm_xarminput_h
