#include <Xclasses/Xclasses.h>
#include <stdio.h>
#include <string.h>

XCprogram *myprg;
/*
XCprogram myprg("class_example",
                XCP_Author,"Jrgen Schmitz",
                XCP_Copyright,"only copied with Xclasses, free to modify for own use",
                XCP_Version,"1.0",
                XCP_EMail,"schmitzj@fsai.fh-trier.de",
                XCP_WWW,"http://fsai.fh-trier.de/~schmitzj/computer/Xclasses",
                XCP_OwnHTML,"This is an example of Xclasses using callbacks for gadget"
                            "identification and a C++ class for complete window.<p>"
                            "<ul><li>the gadgets have a callback (maybe different or the same)"
                            "<li>the program ends if all windows are closed"
                            "</ul>",
                XCP_Desc,"Example program for Xclasses",
                XCP_Done);
*/
static int cid=0;
class finger_prg : Xclasses
{
    void init(appwindow *);
    void finger(gadget *g,int i);
    void quit(gadget *g,int i);
    void handleMenu(gadget *g,int i);
    void close(appwindow *win);
public:
    finger_prg();
    finger_prg(int argc,char *argv[]);
    virtual ~finger_prg();
};
    
void finger_prg::finger(gadget *g,int i)
{
    char uname[9];
    FILE *command;
    char com_str[30]="finger ";
    char buffer[200],*c;
    int pos;
    input *inp_name=(input*)FindObject(FullName(),".username");
    textbox *txt_output=(textbox*)FindObject(FullName(),".textoutput");
    appwindow *mywin=(appwindow*)FindObject(FullName(),".mainwindow");

    inp_name->Input(uname);

    strcat(com_str,uname);
    if (command=popen(com_str,"r"))
    {
        txt_output->AppendText("\n\n");
        while (!feof(command))
        {
            if (fgets(buffer,sizeof(buffer),command))
            {
                c=buffer;
                pos=0;
                while (*c)
                {
                    if (*c=='\t')
                    {
                        *c=' ';
                    }
                    if (*c=='\n')
                        pos=0;
                    else
                        pos++;
                    c++;
                }
                txt_output->AppendText(buffer);
                mywin->Update();
            }
        }
        pclose(command);
    }
}
void finger_prg::quit(gadget *g,int i)
{
    DeleteObjectTree(myprg->FullName(),DOT_NOTBASE);
}
void finger_prg::close(appwindow *win)
{
    delete this;
}
void finger_prg::handleMenu(gadget *g,int i)
{
//  menu *mymenu=(menu*)FindObject(FullName(),".menu");
    menu *mymenu=(menu*)g;
    switch(mymenu->Selection())
    {
        case 0x01000001:
            new finger_prg;
            break;
        case 0x01000002:
            quit(NULL,0);
            break;
    }
}
void finger_prg::init(appwindow *mywin)
{
    char buf[60];
    sprintf(buf,"finger_class_%d",cid++);
    Name(buf);
    ParentClass(myprg);

//    mywin->Name("mainwindow");
//    mywin->ParentClass(this);
    mywin->Title(buf);

    menu *mymenu=new menu;
    mymenu->AddMenu("Program");
    mymenu->Add("Open new window","n",1);
    mymenu->Add("Quit","q",2);
    mymenu->Callback(this,handleMenu);

    group *maingroup=new group; 
    maingroup->Vert();
    maingroup->YDistance(4);
    maingroup->Name("maingroup");
    
    bordergroup *inputgroup=new bordergroup;
    maingroup->Add(inputgroup);
     inputgroup->Name("inputgroup");
     inputgroup->Title("Finger");
     inputgroup->Horiz();
     inputgroup->HelpText("Username to finger\nor empty for all logged in useds");

     input *inp_name=new input;
     inputgroup->Add(inp_name);
      inp_name->Name("username");
      inp_name->MaxChars(8);
      inp_name->Text("Username");
      inp_name->AlwaysMode();
      inp_name->Callback(this,finger);

      fbutton *but_start=new fbutton;
     inputgroup->Add(but_start);
      but_start->Name("fingerbutton");
      but_start->Text("Finger");
      but_start->Weight(50);
      but_start->Callback(this,finger);

    textbox *txt_output=new textbox;
    maingroup->Add(txt_output);
     txt_output->Name("textoutput");
     txt_output->ReadOnly();
     txt_output->AlwaysShowLast();

    ruler *rl_1=new ruler;
    maingroup->Add(rl_1);

    fbutton *but_quit=new fbutton;
    maingroup->Add(but_quit);
     but_quit->Name("quit");
     but_quit->Text("Quit");
     but_quit->Callback(this,quit);

    mywin->Callback(this,close);
    mywin->SetGroup(maingroup);
    mywin->SetMenu(mymenu);

    mywin->Create();
}
finger_prg::finger_prg() : Xclasses()
{
    appwindow *mywin=new appwindow;

    mywin->Name("mainwindow");
    mywin->ParentClass(this);

    mywin->Init();
    mywin->Move(cid,cid);
    init(mywin);
}
finger_prg::finger_prg(int argc, char *argv[]) : Xclasses()
{
    appwindow *mywin=new appwindow;

    mywin->Name("mainwindow");
    mywin->ParentClass(this);

    if (!mywin->Init(argc,argv))
    {
        printf("Error:\nCan't open display %s\n\n",mywin->DisplayName());
        exit(1);
    }
    init(mywin);
}
finger_prg::~finger_prg()
{
    appwindow *mywin=(appwindow*)FindObject(FullName(),".mainwindow");
    mywin->Close();
    DeleteObjectTree(FullName(),DOT_NOTBASE);
}

int main(int argc, char *argv[])
{
    myprg=new XCprogram
    ("class_example",
                XCP_Author,"Jrgen Schmitz",
                XCP_Copyright,"only copied with Xclasses, free to modify for own use",
                XCP_Version,"1.0",
                XCP_EMail,"schmitzj@fsai.fh-trier.de",
                XCP_WWW,"http://fsai.fh-trier.de/~schmitzj/computer/Xclasses",
                XCP_OwnHTML,"This is an example of Xclasses using callbacks for gadget"
                            "identification and a C++ class for complete window.<p>"
                            "<ul><li>the gadgets have a callback (maybe different or the same)"
                            "<li>the program ends if all windows are closed"
                            "</ul>",
                XCP_Desc,"Example program for Xclasses",
                XCP_Done);

    new finger_prg(argc,argv);
    appwindow::NextEvent();
    return 0;
}

