// $Id: AssDialog.cpp,v 1.2 1997/04/17 03:19:43 jharris Exp $

#include "AssDialog.h"

AssDialog::AssDialog( QWidget *parent,
             const char *caption, 
             const char *name )
  : QDialog( parent, name, TRUE )
{
  back   = new QPushButton( this, "Back" );
  back->setToggleButton( TRUE );
  connect( back, SIGNAL(clicked()), SLOT(Back()) );
  next   = new QPushButton( this, "Next" );
  next->setToggleButton( TRUE );
  connect( next, SIGNAL(clicked()), SLOT(Next()) );
  cancel = new QPushButton( this, "Cancel" );
  next->setToggleButton( TRUE );
  connect( cancel, SIGNAL(pressed()), SLOT(Cancel()) );

  setCaption( caption );

  maxPageSize = QSize( 0, 0 );
}  


AssDialog::~AssDialog()
{
  delete back;
  delete next;
  delete cancel;

  for( AssPage *page = pageList.first();
       page;
       page = pageList.next() )
    delete page;

}

void AssDialog::AddPage( AssPage *page )
{
  if( ! page )
    return;

  int w = page->width();
  int h = page->height();
  
  maxPageSize.setWidth( maxPageSize.width() < w ? w : maxPageSize.width() );
  maxPageSize.setHeight( maxPageSize.height() < h ? h : maxPageSize.height() );

  pageList.append( page );

}

int AssDialog::Exec()
{
  if( pageList.isEmpty() )
    return 0;

  currentPage = pageList.first();

  resize( maxPageSize + QSize( 0, 52 ) );

  QFrame *line = new QFrame( this );
  line->setFrameStyle( QFrame::Panel | QFrame::Raised );
  line->setGeometry( 0, maxPageSize.height() + 2, size().width(), 2 );

  QRect bG( 0, 0, 100, 30 );
  QPoint lR( size().width(), size().height() );
  
  lR -= QPoint( 10, 10 );
  bG.moveBottomRight( lR );
  cancel->setGeometry( bG );

  lR -= QPoint( bG.width() + 20, 0 );
  bG.moveBottomRight( lR );
  next->setGeometry( bG );
  
  lR -= QPoint( bG.width() + 20, 0 );
  bG.moveBottomRight( lR );
  back->setGeometry( bG );
  
  currentPage->raise();

  currentPage->direction = TRUE;  
  currentPage->InitPage( TRUE );

  back->setText( currentPage->GetBackLabel() );
  next->setText( currentPage->GetNextLabel() );
  cancel->setText( currentPage->GetCancelLabel() );

  back->setEnabled( FALSE );

  return exec();
}

void AssDialog::Back()
{
  currentPage->ExitPage( FALSE );
  currentPage->hide();
  currentPage = pageList.prev();
  currentPage->direction = FALSE;
  currentPage->InitPage( FALSE );

  back->setText( currentPage->GetBackLabel() );
  next->setText( currentPage->GetNextLabel() );
  cancel->setText( currentPage->GetCancelLabel() );

  currentPage->show();
  currentPage->raise();

  if( currentPage == pageList.getFirst() )
    back->setEnabled( FALSE );
  if( currentPage != pageList.getLast() )
    next->setEnabled( TRUE );
  
}
    
void AssDialog::Next()
{
  currentPage->ExitPage( TRUE );
  currentPage->hide();
  currentPage = pageList.next();
  if( ! currentPage )
  {
    // Next in the last page means to accept the whole thing
    accept();
  } else
  {
    currentPage->direction = TRUE;
    currentPage->InitPage( TRUE );

    back->setText( currentPage->GetBackLabel() );
    next->setText( currentPage->GetNextLabel() );
    cancel->setText( currentPage->GetCancelLabel() );

    currentPage->show();
    currentPage->raise();

    if( currentPage != pageList.getFirst() )
      back->setEnabled( TRUE );
  }
}

void AssDialog::Cancel()
{
  reject();
}

AssPage::AssPage( AssDialog *parent, const char* name )
  : QFrame( parent, name )
{
}

const char *AssPage::GetBackLabel()
{
  return "Back"; 
}

const char *AssPage::GetNextLabel()
{
  return "Next"; 
}

const char *AssPage::GetCancelLabel()
{
  return "Cancel"; 
}

void AssPage::InitPage( bool inOrder )
{
  inOrder = inOrder;
}

void AssPage::ExitPage( bool inOrder )
{
  inOrder = inOrder;
}

